% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bias_functions.R
\name{adjusted_estimate}
\alias{adjusted_estimate}
\alias{adjusted_estimate.lm}
\alias{adjusted_estimate.fixest}
\alias{adjusted_estimate.numeric}
\alias{adjusted_se}
\alias{adjusted_se.numeric}
\alias{adjusted_se.lm}
\alias{adjusted_se.fixest}
\alias{adjusted_ci}
\alias{adjusted_ci.lm}
\alias{adjusted_ci.fixest}
\alias{adjusted_ci.numeric}
\alias{adjusted_t}
\alias{adjusted_t.lm}
\alias{adjusted_t.fixest}
\alias{adjusted_t.numeric}
\alias{adjusted_partial_r2}
\alias{adjusted_partial_r2.numeric}
\alias{adjusted_partial_r2.lm}
\alias{adjusted_partial_r2.fixest}
\alias{bias}
\alias{bias.numeric}
\alias{bias.lm}
\alias{bias.fixest}
\alias{relative_bias}
\alias{relative_bias.lm}
\alias{relative_bias.fixest}
\alias{relative_bias.numeric}
\alias{rel_bias}
\title{Bias-adjusted estimates, standard-errors, t-values and confidence intervals}
\usage{
adjusted_estimate(...)

\method{adjusted_estimate}{lm}(model, treatment, r2dz.x, r2yz.dx, reduce = TRUE, ...)

\method{adjusted_estimate}{fixest}(model, treatment, r2dz.x, r2yz.dx, reduce = TRUE, ...)

\method{adjusted_estimate}{numeric}(estimate, se, dof, r2dz.x, r2yz.dx, reduce = TRUE, ...)

adjusted_se(...)

\method{adjusted_se}{numeric}(se, dof, r2dz.x, r2yz.dx, ...)

\method{adjusted_se}{lm}(model, treatment, r2dz.x, r2yz.dx, ...)

\method{adjusted_se}{fixest}(model, treatment, r2dz.x, r2yz.dx, message = TRUE, ...)

adjusted_ci(...)

\method{adjusted_ci}{lm}(
  model,
  treatment,
  r2dz.x,
  r2yz.dx,
  which = c("both", "lwr", "upr"),
  reduce = TRUE,
  alpha = 0.05,
  ...
)

\method{adjusted_ci}{fixest}(
  model,
  treatment,
  r2dz.x,
  r2yz.dx,
  which = c("both", "lwr", "upr"),
  reduce = TRUE,
  alpha = 0.05,
  message = T,
  ...
)

\method{adjusted_ci}{numeric}(
  estimate,
  se,
  dof,
  r2dz.x,
  r2yz.dx,
  which = c("both", "lwr", "upr"),
  reduce = TRUE,
  alpha = 0.05,
  ...
)

adjusted_t(...)

\method{adjusted_t}{lm}(model, treatment, r2dz.x, r2yz.dx, reduce = TRUE, h0 = 0, ...)

\method{adjusted_t}{fixest}(
  model,
  treatment,
  r2dz.x,
  r2yz.dx,
  reduce = TRUE,
  h0 = 0,
  message = T,
  ...
)

\method{adjusted_t}{numeric}(estimate, se, dof, r2dz.x, r2yz.dx, reduce = TRUE, h0 = 0, ...)

adjusted_partial_r2(...)

\method{adjusted_partial_r2}{numeric}(
  estimate,
  se,
  dof,
  r2dz.x,
  r2yz.dx,
  reduce = TRUE,
  h0 = 0,
  ...
)

\method{adjusted_partial_r2}{lm}(
  model,
  treatment,
  r2dz.x,
  r2yz.dx,
  reduce = TRUE,
  h0 = 0,
  ...
)

\method{adjusted_partial_r2}{fixest}(
  model,
  treatment,
  r2dz.x,
  r2yz.dx,
  reduce = TRUE,
  h0 = 0,
  ...
)

bias(...)

\method{bias}{numeric}(se, dof, r2dz.x, r2yz.dx, ...)

\method{bias}{lm}(model, treatment, r2dz.x, r2yz.dx, ...)

\method{bias}{fixest}(model, treatment, r2dz.x, r2yz.dx, ...)

relative_bias(...)

\method{relative_bias}{lm}(model, treatment, r2dz.x, r2yz.dx, ...)

\method{relative_bias}{fixest}(model, treatment, r2dz.x, r2yz.dx, ...)

\method{relative_bias}{numeric}(estimate, se, dof, r2dz.x, r2yz.dx, ...)

rel_bias(r.est, est)
}
\arguments{
\item{...}{arguments passed to other methods.}

\item{model}{An \code{lm} or \code{fixest} object with the outcome regression.}

\item{treatment}{A character vector with the name of the treatment variable
of the model.}

\item{r2dz.x}{hypothetical partial R2 of unobserved confounder
Z with treatment D, given covariates X.}

\item{r2yz.dx}{hypothetical partial R2 of unobserved confounder Z
with outcome Y, given covariates X and treatment D.}

\item{reduce}{should the bias adjustment reduce or increase the
absolute value of the estimated coefficient? Default is \code{TRUE}.}

\item{estimate}{Coefficient estimate.}

\item{se}{standard error of the coefficient estimate.}

\item{dof}{residual degrees of freedom of the regression.}

\item{message}{should messages be printed? Default = TRUE.}

\item{which}{which limit of the confidence interval to show? Options are "both", lower limit ("lwr") or upper limit ("upr").}

\item{alpha}{significance level.}

\item{h0}{Null hypothesis for computation of the t-value. Default is zero.}

\item{r.est}{restricted estimate. A numerical vector.}

\item{est}{unrestricted estimate. A numerical vector.}
}
\value{
Numeric vector with bias, adjusted estimate, standard error, or t-value.
}
\description{
These functions compute bias adjusted estimates (\code{adjusted_estimate}),
 standard-errors (\code{adjusted_se}) and t-values (\code{adjusted_t}),
 given a hypothetical strength of the confounder in the partial R2 parameterization.

The functions work either with an \code{\link{lm}} object, or directly
passing in numerical inputs, such as the
current coefficient estimate, standard error and degrees of freedom.
}
\examples{
# loads data
data("darfur")

# fits model
model <- lm(peacefactor ~ directlyharmed + age +
                          farmer_dar + herder_dar +
                           pastvoted + hhsize_darfur +
                           female + village, data = darfur)

# computes adjusted estimate for confounder with  r2dz.x = 0.05, r2yz.dx = 0.05
adjusted_estimate(model, treatment = "directlyharmed", r2dz.x = 0.05, r2yz.dx = 0.05)

# computes adjusted SE for confounder with  r2dz.x = 0.05, r2yz.dx = 0.05
adjusted_se(model, treatment = "directlyharmed", r2dz.x = 0.05, r2yz.dx = 0.05)

# computes adjusted t-value for confounder with  r2dz.x = 0.05, r2yz.dx = 0.05
adjusted_t(model, treatment = "directlyharmed", r2dz.x = 0.05, r2yz.dx = 0.05)

# Alternatively, pass in numerical values directly.
adjusted_estimate(estimate = 0.09731582, se = 0.02325654,
                  dof = 783, r2dz.x = 0.05, r2yz.dx = 0.05)

adjusted_se(estimate = 0.09731582, se = 0.02325654,
            dof = 783, r2dz.x = 0.05, r2yz.dx = 0.05)

adjusted_t(estimate = 0.09731582, se = 0.02325654,
           dof = 783, r2dz.x = 0.05, r2yz.dx = 0.05)

}
\references{
Cinelli, C. and Hazlett, C. (2020), "Making Sense of Sensitivity: Extending Omitted Variable Bias." Journal of the Royal Statistical Society, Series B (Statistical Methodology).
}
