context("Testing Bias Adjusted Critical Values")

test_that("Table 1",
          {
            dof <- 10^(2:6)
            r2 <- seq(0, 0.05, by = 0.01)
            vars <- expand.grid(r2 = r2,dof = dof)
            table1 <- with(vars, adjusted_critical_value(r2, r2, dof))
            dim(table1) <- c(6, 5)


            table.check <- structure(c(1.99421307002271, 2.09471685154863, 2.19624357893315,
                                       2.29881691956279, 2.40246136048657, 2.50720224606528, 1.96332336835585,
                                       2.28114423143771, 2.60219993335579, 2.92656531695775, 3.25431781709165,
                                       3.58553757966347, 1.96029928103589, 2.9653370962951, 3.98060437014031,
                                       5.00633777643675, 6.04278218567452, 7.09019104146166, 1.95999750778526,
                                       5.1382061386039, 8.34876315778466, 11.5924169938043, 14.8699419951433,
                                       18.1821396208615, 1.95996496452278, 12.0103431171149, 22.163015855567,
                                       32.4203499185314, 42.7847940109091, 53.2588825687805), .Dim = 6:5)
            expect_equal(object = table1, expected = table.check)
          }
)
