% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/permute.R
\name{permute_design}
\alias{permute_design}
\title{Permute the design matrix so that it is approximately correlated with
the surrogate variables.}
\usage{
permute_design(
  design_perm,
  sv,
  target_cor,
  method = c("hungarian", "marriage")
)
}
\arguments{
\item{design_perm}{A numeric design matrix whose rows are to be permuted
(thus controlling the amount by which they are correlated with the
surrogate variables). The rows index the samples and the columns index
the variables. The intercept should \emph{not} be included
(though see Section "Unestimable Components").}

\item{sv}{A matrix of surrogate variables}

\item{target_cor}{A numeric matrix of target correlations between the
variables in \code{design_perm} and the surrogate variables. The
rows index the observed covariates and the columns index the surrogate
variables. That is, \code{target_cor[i, j]} specifies the target
correlation between the \code{i}th column of \code{design_perm} and the
\code{j}th surrogate variable. The surrogate variables are estimated
either using factor analysis or surrogate variable analysis (see the
parameter \code{use_sva}).
The number of columns in \code{target_cor} specifies the number of
surrogate variables. Set \code{target_cor} to \code{NULL} to indicate
that \code{design_perm} and the surrogate variables are independent.}

\item{method}{Should we use the Gale-Shapley algorithm
for stable marriages (\code{"marriage"}) (Gale and Shapley, 1962)
as implemented in the matchingR package, or the Hungarian algorithm
(Papadimitriou and Steiglitz, 1982) (\code{"hungarian"})
as implemented in the clue package (Hornik, 2005)? The
Hungarian method almost always works better, so is the default.}
}
\value{
A list with two elements:
\describe{
  \item{\code{design_perm}}{A row-permuted version of the user-provided
      \code{design_perm}.}
  \item{\code{latent_var}}{A matrix of the latent variables on which
      \code{design_perm} was matched.}
}
}
\description{
Permute the design matrix so that it is approximately correlated with
the surrogate variables.
}
\references{
\itemize{
  \item{Gale, David, and Lloyd S. Shapley. "College admissions and the stability of marriage." \emph{The American Mathematical Monthly} 69, no. 1 (1962): 9-15. \doi{10.1080/00029890.1962.11989827}.}
  \item{C. Papadimitriou and K. Steiglitz (1982), Combinatorial Optimization: Algorithms and Complexity. Englewood Cliffs: Prentice Hall.}
  \item{Hornik K (2005). "A CLUE for CLUster Ensembles." \emph{Journal of Statistical Software}, 14(12). \doi{10.18637/jss.v014.i12}. \doi{10.18637/jss.v014.i12}.}
}
}
\author{
David Gerard
}
