% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/components.R, R/documentation.R, R/examples.R,
%   R/inputs.R
\name{ColorPicker}
\alias{ColorPicker}
\alias{ColorPicker.shinyInput}
\alias{updateColorPicker.shinyInput}
\title{ColorPicker}
\usage{
ColorPicker(...)

ColorPicker.shinyInput(inputId, ..., value = defaultValue)

updateColorPicker.shinyInput(
  session = shiny::getDefaultReactiveDomain(),
  inputId,
  ...
)
}
\arguments{
\item{...}{Props to pass to the component.
The allowed props are listed below in the \bold{Details} section.}

\item{inputId}{ID of the component.}

\item{value}{Starting value.}

\item{session}{Object passed as the \code{session} argument to Shiny server.}
}
\value{
Object with \code{shiny.tag} class suitable for use in the UI of a Shiny app.
The update functions return nothing (called for side effects).
}
\description{
The color picker (\code{ColorPicker}) is used to browse through and select colors. By default, it lets people navigate through colors on a color spectrum; or specify a color in either Red-Green-Blue (RGB); or alpha color code; or Hexadecimal textboxes.

For more details and examples visit the \href{https://developer.microsoft.com/en-us/fluentui#/controls/web/ColorPicker}{official docs}.
The R package cannot handle each and every case, so for advanced use cases
you need to work using the original docs to achieve the desired result.
}
\details{
\itemize{
\item \bold{ alphaLabel } \code{string} \cr Label for the alpha textfield.
\item \bold{ alphaSliderHidden } \code{boolean} \cr Whether to hide the alpha (or transparency) slider and text field.
\item \bold{ alphaType } \code{'alpha' | 'transparency' | 'none'} \cr \code{alpha} (the default) means display a slider and text field for editing alpha values. \code{transparency} also displays a slider and text field but for editing transparency values. \code{none} hides these controls.
}

Alpha represents the opacity of the color, whereas transparency represents the transparentness of the color: i.e. a 30\% transparent color has 70\% opaqueness.
\itemize{
\item \bold{ blueLabel } \code{string} \cr Label for the blue text field.
\item \bold{ className } \code{string} \cr Additional CSS class(es) to apply to the ColorPicker.
\item \bold{ color } \code{IColor | string} \cr Object or CSS-compatible string to describe the color.
\item \bold{ componentRef } \verb{IRefObject<IColorPicker>} \cr Gets the component ref.
\item \bold{ greenLabel } \code{string} \cr Label for the green text field.
\item \bold{ hexLabel } \code{string} \cr Label for the hex text field.
\item \bold{ onChange } \verb{(ev: React.SyntheticEvent<HTMLElement>, color: IColor) => void} \cr Callback for when the user changes the color. (Not called when the color is changed via props.)
\item \bold{ redLabel } \code{string} \cr Label for the red text field.
\item \bold{ showPreview } \code{boolean} \cr Whether to show color preview box.
\item \bold{ strings } \code{IColorPickerStrings} \cr Labels for elements within the ColorPicker. Defaults are provided in English only.
\item \bold{ styles } \verb{IStyleFunctionOrObject<IColorPickerStyleProps, IColorPickerStyles>} \cr Call to provide customized styling that will layer on top of the variant rules.
\item \bold{ theme } \code{ITheme} \cr Theme (provided through customization).
\item \bold{ ariaDescription } \code{string} \cr Detailed description for how to use the color rectangle. Moving the thumb horizontally adjusts saturation and moving it vertically adjusts value (essentially, brightness).
\item \bold{ ariaLabel } \code{string} \cr Label of the ColorRectangle for the benefit of screen reader users.
\item \bold{ ariaValueFormat } \code{string} \cr Format string for the color rectangle's current value as read by screen readers. The string must include descriptions and two placeholders for the current values: \code{{0}} for saturation and \code{{1}} for value/brightness.
\item \bold{ className } \code{string} \cr Additional CSS class(es) to apply to the ColorRectangle.
\item \bold{ color } \code{IColor} \cr Current color of the rectangle.
\item \bold{ componentRef } \verb{IRefObject<IColorRectangle>} \cr Gets the component ref.
\item \bold{ minSize } \code{number} \cr Minimum width and height.
\item \bold{ onChange } \verb{(ev: React.MouseEvent | React.KeyboardEvent, color: IColor) => void} \cr Callback for when the color changes.
\item \bold{ styles } \verb{IStyleFunctionOrObject<IColorRectangleStyleProps, IColorRectangleStyles>} \cr Call to provide customized styling that will layer on top of the variant rules.
\item \bold{ theme } \code{ITheme} \cr Theme (provided through customization).
\item \bold{ ariaLabel } \code{string} \cr Label of the ColorSlider for the benefit of screen reader users.
\item \bold{ className } \code{string} \cr Additional CSS class(es) to apply to the ColorSlider.
\item \bold{ componentRef } \verb{IRefObject<IColorSlider>} \cr Gets the component ref.
\item \bold{ isAlpha } \code{boolean} \cr If true, the slider represents an alpha slider and will display a gray checkered pattern in the background. Otherwise, the slider represents a hue slider.
\item \bold{ maxValue } \code{number} \cr Maximum value of the slider.
\item \bold{ minValue } \code{number} \cr Minimum value of the slider.
\item \bold{ onChange } \verb{(event: React.MouseEvent | React.KeyboardEvent, newValue?: number) => void} \cr Callback issued when the value changes.
\item \bold{ overlayColor } \code{string} \cr Hex color to use when rendering an alpha or transparency slider's overlay, \emph{without} the \verb{#}.
\item \bold{ overlayStyle } \code{React.CSSProperties} \cr Custom style for the overlay element.
\item \bold{ styles } \verb{IStyleFunctionOrObject<IColorSliderStyleProps, IColorSliderStyles>} \cr Call to provide customized styling that will layer on top of the variant rules.
\item \bold{ theme } \code{ITheme} \cr Theme (provided through customization).
\item \bold{ thumbColor } \code{string} \cr CSS-compatible string for the color of the thumb element.
\item \bold{ type } \code{'hue' | 'alpha' | 'transparency'} \cr Type of slider to display.
\item \bold{ value } \code{number} \cr Current value of the slider.
}
}
\examples{
library(shiny)
library(shiny.fluent)

ui <- function(id) {
  ns <- NS(id)
  div(
    ColorPicker.shinyInput(ns("color"), value = "#00FF01"),
    textOutput(ns("colorValue"))
  )
}

server <- function(id) {
  moduleServer(id, function(input, output, session) {
    output$colorValue <- renderText({
      sprintf("Value: \%s", input$color)
    })
  })
}

if (interactive()) {
  shinyApp(ui("app"), function(input, output) server("app"))
}
}
