% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/components.R, R/documentation.R, R/examples.R,
%   R/inputs.R
\name{SpinButton}
\alias{SpinButton}
\alias{SpinButton.shinyInput}
\alias{updateSpinButton.shinyInput}
\title{SpinButton}
\usage{
SpinButton(...)

SpinButton.shinyInput(inputId, ..., value = defaultValue)

updateSpinButton.shinyInput(
  session = shiny::getDefaultReactiveDomain(),
  inputId,
  ...
)
}
\arguments{
\item{...}{Props to pass to the component.
The allowed props are listed below in the \bold{Details} section.}

\item{inputId}{ID of the component.}

\item{value}{Starting value.}

\item{session}{Object passed as the \code{session} argument to Shiny server.}
}
\value{
Object with \code{shiny.tag} class suitable for use in the UI of a Shiny app.
The update functions return nothing (called for side effects).
}
\description{
A spin button (\code{SpinButton}) allows someone to incrementally adjust a value in small steps. It’s mainly used for numeric values, but other values are supported too.

For more details and examples visit the \href{https://developer.microsoft.com/en-us/fluentui#/controls/web/SpinButton}{official docs}.
The R package cannot handle each and every case, so for advanced use cases
you need to work using the original docs to achieve the desired result.
}
\details{
\itemize{
\item \bold{ ariaDescribedBy } \code{string} \cr ID of a label which describes the control, if not using the default label.
\item \bold{ ariaLabel } \code{string} \cr A description of the control for the benefit of screen reader users.
\item \bold{ ariaPositionInSet } \code{number} \cr The position in the parent set (if in a set).
\item \bold{ ariaSetSize } \code{number} \cr The total size of the parent set (if in a set).
\item \bold{ ariaValueNow } \code{number} \cr Sets the control's aria-valuenow. This is the numeric form of \code{value}. Providing this only makes sense when using as a controlled component.
\item \bold{ ariaValueText } \code{string} \cr
\item \bold{ className } \code{string} \cr Custom className for the control.
\item \bold{ componentRef } \verb{IRefObject<ISpinButton>} \cr Gets the component ref.
\item \bold{ decrementButtonAriaLabel } \code{string} \cr Accessible label text for the decrement button (for screen reader users).
\item \bold{ decrementButtonIcon } \code{IIconProps} \cr Custom props for the decrement button.
\item \bold{ defaultValue } \code{string} \cr Initial value of the control. Updates to this prop will not be respected.
}

Use this if you intend for the SpinButton to be an uncontrolled component which maintains its own value. Mutually exclusive with \code{value}.
\itemize{
\item \bold{ disabled } \code{boolean} \cr Whether or not the control is disabled.
\item \bold{ downArrowButtonStyles } \verb{Partial<IButtonStyles>} \cr Custom styles for the down arrow button.
}

Note: The buttons are in a checked state when arrow keys are used to incremenent/decrement the SpinButton. Use \code{rootChecked} instead of \code{rootPressed} for styling when that is the case.
\itemize{
\item \bold{ getClassNames } \verb{(theme: ITheme, disabled: boolean, isFocused: boolean, keyboardSpinDirection: KeyboardSpinDirection, labelPosition?: Position, className?: string) => ISpinButtonClassNames} \cr Custom function for providing the classNames for the control. Can be used to provide all styles for the component instead of applying them on top of the default styles.
\item \bold{ iconButtonProps } \code{IButtonProps} \cr Additional props for the up and down arrow buttons.
\item \bold{ iconProps } \code{IIconProps} \cr Props for an icon to display alongside the control's label.
\item \bold{ incrementButtonAriaLabel } \code{string} \cr Accessible label text for the increment button (for screen reader users).
\item \bold{ incrementButtonIcon } \code{IIconProps} \cr Custom props for the increment button.
\item \bold{ inputProps } \verb{React.InputHTMLAttributes<HTMLElement | HTMLInputElement>} \cr Additional props for the input field.
\item \bold{ keytipProps } \code{IKeytipProps} \cr Keytip for the control.
\item \bold{ label } \code{string} \cr Descriptive label for the control.
\item \bold{ labelPosition } \code{Position} \cr Where to position the control's label.
\item \bold{ max } \code{number} \cr Max value of the control.
\item \bold{ min } \code{number} \cr Min value of the control.
\item \bold{ onBlur } \verb{React.FocusEventHandler<HTMLInputElement>} \cr Callback for when the control loses focus.
\item \bold{ onDecrement } \verb{(value: string, event?: React.MouseEvent<HTMLElement> | React.KeyboardEvent<HTMLElement>) => string | void} \cr Callback for when the decrement button or down arrow key is pressed.
\item \bold{ onFocus } \verb{React.FocusEventHandler<HTMLInputElement>} \cr Callback for when the user focuses the control.
\item \bold{ onIncrement } \verb{(value: string, event?: React.MouseEvent<HTMLElement> | React.KeyboardEvent<HTMLElement>) => string | void} \cr Callback for when the increment button or up arrow key is pressed.
\item \bold{ onValidate } \verb{(value: string, event?: React.SyntheticEvent<HTMLElement>) => string | void} \cr Callback for when the entered value should be validated.
\item \bold{ precision } \code{number} \cr How many decimal places the value should be rounded to.
}

The default is calculated based on the precision of \code{step}: i.e. if step = 1, precision = 0. step = 0.0089, precision = 4. step = 300, precision = 2. step = 23.00, precision = 2.
\itemize{
\item \bold{ step } \code{number} \cr Difference between two adjacent values of the control. This value is used to calculate the precision of the input if no \code{precision} is given. The precision calculated this way will always be \>= 0.
\item \bold{ styles } \verb{Partial<ISpinButtonStyles>} \cr Custom styling for individual elements within the control.
\item \bold{ theme } \code{ITheme} \cr Theme provided by HOC.
\item \bold{ title } \code{string} \cr A more descriptive title for the control, visible on its tooltip.
\item \bold{ upArrowButtonStyles } \verb{Partial<IButtonStyles>} \cr Custom styles for the up arrow button.
}

Note: The buttons are in a checked state when arrow keys are used to incremenent/decrement the SpinButton. Use \code{rootChecked} instead of \code{rootPressed} for styling when that is the case.
\itemize{
\item \bold{ value } \code{string} \cr Current value of the control.
}

Use this if you intend to pass in a new value as a result of change events. Mutually exclusive with \code{defaultValue}.
}
\section{Best practices}{
\subsection{Layout}{
\itemize{
\item Use a spin button when you need to incrementally change a value.
\item Use a spin button when values are tied to a unit of measure.
\item Don't use a spin button for binary settings.
\item Don't use a spin button for a range of three values or less.
\item Place labels to the left of the spin button control. For example, "Length of ruler (cm)".
\item Spin button width should adjust to fit the number values.
}
}

\subsection{Content}{
\itemize{
\item Include a label indicating what value the spin button changes.
}
}
}

\examples{
library(shiny)
library(shiny.fluent)

ui <- function(id) {
  ns <- NS(id)
  div(
    SpinButton.shinyInput(ns("spin"), value = 15, min = 0, max = 50, step = 5),
    textOutput(ns("spinValue"))
  )
}

server <- function(id) {
  moduleServer(id, function(input, output, session) {
    output$spinValue <- renderText({
      sprintf("Value: \%s", input$spin)
    })
  })
}

if (interactive()) {
  shinyApp(ui("app"), function(input, output) server("app"))
}
}
