% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/database_create.R
\name{DBI_tables_create}
\alias{DBI_tables_create}
\title{Create RegLog-valid database tables with DBI}
\usage{
DBI_tables_create(
  conn,
  account_name = "account",
  reset_code_name = "reset_code",
  use_log = FALSE,
  log_name = "logs",
  user_data = NULL,
  hash_passwords = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{conn}{DBI connection object}

\item{account_name}{Name of the table for storing user accounts credentials.
Defaults to 'account'. Mandatory table.}

\item{reset_code_name}{Name of the table for storing generated password reset
codes. Defaults to 'reset_code'. Mandatory table.}

\item{use_log}{Should the table for keeping RegLogServer logs be
also created? Defaults to FALSE}

\item{log_name}{Name of the table for storing logs from RegLogServer object.
Used only if \code{use_log = TRUE}. Defaults to \code{logs}}

\item{user_data}{If you wish to import existing user database, you can input
data.frame with that table in this argument. It should contain columns:
username, password, email. Defaults to NULL.}

\item{hash_passwords}{If you are importing table of users upon tables creation,
you can also specify if the password should be hashed using \code{scrypt::hashPassword}.
Defaults to \code{FALSE}. If you have unhashed passwords in imported table, set
this option to \code{TRUE}.}

\item{verbose}{Boolean specific if the actions made by function should be
printed back to the console. Defaults to \code{TRUE}.}
}
\value{
List with results of the creation
}
\description{
Create RegLog-valid database tables with DBI
}
\details{
Currently, the function is tested and working correctly for
SQLite, MySQL, MariaDB and PostrgreSQL databases. If you want to use another
DBI-supported database, you need to create tables in other ways.

Created tables should have following structure:
\itemize{
\item account (default name)
\itemize{
\item id: integer, primary key, auto-increment
\item username: varchar(255), NOT NULL, unique key
\item password: varchar(255), NOT NULL
\item email: varchar(255), NOT NULL, unique key
\item create_time: datetime, NOT NULL
\item update_time: datetime, NOT NULL
}
\item reset_code (default name)
\itemize{
\item id: integer, primary key, auto-increment
\item user_id: integer, NOT NULL, key
\item reset_code: varchar(10), NOT NULL
\item used: tinyint, NOT NULL
\item create_time: datetime, NOT NULL
\item update_time: datetime, NOT NULL
}
\item logs (default name, optional)
\itemize{
\item id: integer, primary key, auto-increment
\item time: datetime, NOT NULL
\item session: varchar(255), NOT NULL
\item direction: varchar(255), NOT NULL
\item type: varchar(255), NOT NULL
\item note: varchar(255)
}
}
}
\examples{
library(shiny.reglog)

# create a tenporary SQLite database
conn <- DBI::dbConnect(
  RSQLite::SQLite(),
  dbname = ":memory:"
)

# mockup user data
user_data <- 
  data.frame(username = c("Whatever", "Hanuka", "Helsinki", "How_come"), 
             password = c("&f5*MSYj^niDt=V'3.[dyEX.C/", "\%}&B[fs\\\\}5PKE@,*+V\\\\tx9\"at]", 
                    "35z*ofW\\\\'G_8,@vCC`]~?e$Jm\%", "s:;r_eLn?-D6;oA-=\"^R(-Ew<x"), 
             email = c("what@mil.com", "hehe@soso.so", "nider@what.no", "crazzz@simpsy.com"))

# create the tables and input the data (hashing the passwords in the process)
DBI_tables_create(conn = conn,
                  user_data = user_data,
                  hash_passwords = TRUE,
                  verbose = FALSE)

# check generater tables
DBI::dbListTables(conn = conn)

# check the "user" table for user data
DBI::dbReadTable(conn = conn,
                 "account")

# disconnect
DBI::dbDisconnect(conn = conn)
}
\seealso{
Other RegLog databases: 
\code{\link{gsheet_tables_create}()},
\code{\link{mongo_tables_create}()}
}
\concept{RegLog databases}
