% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modal-functionality.R
\name{twBtnOpenModal}
\alias{twBtnOpenModal}
\title{Creates a button to open a Modal Dialog}
\usage{
twBtnOpenModal(
  btn_id,
  btn_label,
  btn_class = NULL,
  icon = NULL,
  modal_id = "shiny-modal"
)
}
\arguments{
\item{btn_id}{ID of the button}

\item{btn_label}{Label for the button}

\item{btn_class}{Classes to style the button}

\item{icon}{an optional icon for the button}

\item{modal_id}{ID of the modal, make sure that the IDs are identical to the
one used in \code{\link[=twModalDialog]{twModalDialog()}}}
}
\value{
a list with a \code{shiny.tag} class
}
\description{
Creates a button to open a Modal Dialog
}
\examples{
ui <- div(
  use_tailwind(),
  class = "h-screen bg-stone-100 p-10",
  twBtnOpenModal(
    "open_modal", "Show Modal",
    btn_class = "px-5 py-2 bg-rose-500 hover:bg-rose-700 text-white cursor-pointer rounded-md"
  ),
  twModalDialog(p("Hello World"), )
)

server <- function(input, output, session) {
  observeEvent(input$open_modal, {
    print("Modal Opened")
  })
  observeEvent(input$submit, {
    print("Modal Closed - Submitted")
  })
  observeEvent(input$close, {
    print("Modal Closed - Closed")
  })
}
if (interactive() == TRUE) shinyApp(ui, server)
}
