#' @title Chakra icons
#' @description List of Chakra icons.
#'
#' @return The names of the Chakra icons in a vector.
#'
#' @export
#' @details See \href{https://chakra-ui.com/docs/media-and-icons/icon#all-icons}{all chakra icons}.
#'
#' @examples
#' chakraIcons()
chakraIcons <- function(){
  c(
    "AddIcon",
    "ArrowBackIcon",
    "ArrowDownIcon",
    "ArrowForwardIcon",
    "ArrowLeftIcon",
    "ArrowRightIcon",
    "ArrowUpIcon",
    "ArrowUpDownIcon",
    "AtSignIcon",
    "AttachmentIcon",
    "BellIcon",
    "CalendarIcon",
    "ChatIcon",
    "CheckIcon",
    "CheckCircleIcon",
    "ChevronDownIcon",
    "ChevronLeftIcon",
    "ChevronRightIcon",
    "ChevronUpIcon",
    "CloseIcon",
    "CopyIcon",
    "DeleteIcon",
    "DownloadIcon",
    "DragHandleIcon",
    "EditIcon",
    "EmailIcon",
    "ExternalLinkIcon",
    "HamburgerIcon",
    "InfoIcon",
    "InfoOutlineIcon",
    "LinkIcon",
    "LockIcon",
    "MinusIcon",
    "MoonIcon",
    "NotAllowedIcon",
    "PhoneIcon",
    "PlusSquareIcon",
    "QuestionIcon",
    "QuestionOutlineIcon",
    "RepeatIcon",
    "RepeatClockIcon",
    "SearchIcon",
    "Search2Icon",
    "SettingsIcon",
    "SmallAddIcon",
    "SmallCloseIcon",
    "SpinnerIcon",
    "StarIcon",
    "SunIcon",
    "TimeIcon",
    "TriangleDownIcon",
    "TriangleUpIcon",
    "UnlockIcon",
    "UpDownIcon",
    "ViewIcon",
    "ViewOffIcon",
    "WarningIcon",
    "WarningTwoIcon"
  )
}

#' @title Super tiny icons
#' @description List of super tiny icons.
#'
#' @return The names of the super tiny icons in a vector.
#'
#' @export
#' @details See \href{https://github.com/edent/SuperTinyIcons#whats-available-so-far}{all super tiny icons}.
#'
#' @examples
#' superTinyIcons()
superTinyIcons <- function(){
  c(
    "AcastTinyIcon",
    "AccessTinyIcon",
    "AdobeTinyIcon",
    "AirbnbTinyIcon",
    "AmazonTinyIcon",
    "Amazon_alexaTinyIcon",
    "Amazon_s3TinyIcon",
    "AmberframeworkTinyIcon",
    "AndotpTinyIcon",
    "AndroidTinyIcon",
    "AngellistTinyIcon",
    "AngularTinyIcon",
    "AnsibleTinyIcon",
    "ApereoTinyIcon",
    "AppleTinyIcon",
    "Apple_musicTinyIcon",
    "Arch_linuxTinyIcon",
    "Auth0TinyIcon",
    "AuthyTinyIcon",
    "BackboneTinyIcon",
    "BadooTinyIcon",
    "BaiduTinyIcon",
    "BandcampTinyIcon",
    "BehanceTinyIcon",
    "BingTinyIcon",
    "BitbucketTinyIcon",
    "BitcoinTinyIcon",
    "BitwardenTinyIcon",
    "BloggerTinyIcon",
    "BluetoothTinyIcon",
    "BraveTinyIcon",
    "BriarTinyIcon",
    "BufferTinyIcon",
    "BugcrowdTinyIcon",
    "CalendarTinyIcon",
    "CentosTinyIcon",
    "ChromeTinyIcon",
    "ChromiumTinyIcon",
    "CitrixTinyIcon",
    "Citrix_compactTinyIcon",
    "ClojureTinyIcon",
    "CloudflareTinyIcon",
    "CodebergTinyIcon",
    "CodepenTinyIcon",
    "CoffeescriptTinyIcon",
    "CoilTinyIcon",
    "CoinpotTinyIcon",
    "ColaboratoryTinyIcon",
    "CplusplusTinyIcon",
    "CrystalTinyIcon",
    "Css3TinyIcon",
    "DartTinyIcon",
    "DatacampTinyIcon",
    "DebianTinyIcon",
    "DeezerTinyIcon",
    "DeliciousTinyIcon",
    "Dev_toTinyIcon",
    "DigidentityTinyIcon",
    "DigitaloceanTinyIcon",
    "DiscordTinyIcon",
    "DisqusTinyIcon",
    "DjangoprojectTinyIcon",
    "DockerTinyIcon",
    "DribbbleTinyIcon",
    "DroneTinyIcon",
    "DropboxTinyIcon",
    "DrupalTinyIcon",
    "DuckduckgoTinyIcon",
    "EaTinyIcon",
    "EbayTinyIcon",
    "EdgeTinyIcon",
    "ElasticTinyIcon",
    "ElementTinyIcon",
    "ElementaryosTinyIcon",
    "EmailTinyIcon",
    "EpubTinyIcon",
    "EspressifTinyIcon",
    "EthereumTinyIcon",
    "EtsyTinyIcon",
    "EvernoteTinyIcon",
    "FacebookTinyIcon",
    "FinderTinyIcon",
    "FirefoxTinyIcon",
    "FlattrTinyIcon",
    "FlickrTinyIcon",
    "FlutterTinyIcon",
    "Foobar2000TinyIcon",
    "FreebsdTinyIcon",
    "FreecodecampTinyIcon",
    "FriendicaTinyIcon",
    "FritzTinyIcon",
    "GandiTinyIcon",
    "GatehubTinyIcon",
    "GhostTinyIcon",
    "GitTinyIcon",
    "GiteaTinyIcon",
    "GithubTinyIcon",
    "GitlabTinyIcon",
    "GlitchTinyIcon",
    "GmailTinyIcon",
    "Gmail_oldTinyIcon",
    "GoTinyIcon",
    "GogcomTinyIcon",
    "GojekTinyIcon",
    "GoodreadsTinyIcon",
    "GoogleTinyIcon",
    "Google_calendarTinyIcon",
    "Google_collaborative_content_toolsTinyIcon",
    "Google_docs_editorsTinyIcon",
    "Google_driveTinyIcon",
    "Google_drive_oldTinyIcon",
    "Google_mapsTinyIcon",
    "Google_maps_oldTinyIcon",
    "Google_meetTinyIcon",
    "Google_playTinyIcon",
    "Google_plusTinyIcon",
    "Google_podcastsTinyIcon",
    "Google_scholarTinyIcon",
    "GradleTinyIcon",
    "GrafanaTinyIcon",
    "GuacamoleTinyIcon",
    "GuildedTinyIcon",
    "HackernewsTinyIcon",
    "HackeroneTinyIcon",
    "HamlTinyIcon",
    "HerokuTinyIcon",
    "HomekitTinyIcon",
    "HpTinyIcon",
    "Html5TinyIcon",
    "HuluTinyIcon",
    "HumblebundleTinyIcon",
    "I18nextTinyIcon",
    "IbmTinyIcon",
    "IheartradioTinyIcon",
    "ImdbTinyIcon",
    "ImgurTinyIcon",
    "InstagramTinyIcon",
    "IntelTinyIcon",
    "IntercomTinyIcon",
    "Internet_archiveTinyIcon",
    "Itch_ioTinyIcon",
    "Itunes_podcastsTinyIcon",
    "JacobinTinyIcon",
    "JavaTinyIcon",
    "JavascriptTinyIcon",
    "JellyfinTinyIcon",
    "JsonTinyIcon",
    "JuliaTinyIcon",
    "KaggleTinyIcon",
    "KeepassdxTinyIcon",
    "KemalTinyIcon",
    "KeskonfaiTinyIcon",
    "KeybaseTinyIcon",
    "KickstarterTinyIcon",
    "KoFiTinyIcon",
    "KodiTinyIcon",
    "KotlinTinyIcon",
    "LaravelTinyIcon",
    "LastpassTinyIcon",
    "LiberapayTinyIcon",
    "LineTinyIcon",
    "LinkedinTinyIcon",
    "LinuxTinyIcon",
    "Linux_mintTinyIcon",
    "LobstersTinyIcon",
    "LockTinyIcon",
    "LogitechTinyIcon",
    "LuckyframeworkTinyIcon",
    "MacosTinyIcon",
    "MailTinyIcon",
    "MailchimpTinyIcon",
    "MaltTinyIcon",
    "ManjaroTinyIcon",
    "MarkdownTinyIcon",
    "MastodonTinyIcon",
    "MattermostTinyIcon",
    "MediumTinyIcon",
    "MeetupTinyIcon",
    "MessengerTinyIcon",
    "MicroformatsTinyIcon",
    "MicrosoftTinyIcon",
    "MinecraftTinyIcon",
    "NetflixTinyIcon",
    "NextcloudTinyIcon",
    "NhsTinyIcon",
    "NpmTinyIcon",
    "OkTinyIcon",
    "OlympicsTinyIcon",
    "OpenbenchesTinyIcon",
    "OpenbugbountyTinyIcon",
    "OpencastTinyIcon",
    "OpencollectiveTinyIcon",
    "OpencoresTinyIcon",
    "OpensourceTinyIcon",
    "OpenvpnTinyIcon",
    "OperaTinyIcon",
    "OrcidTinyIcon",
    "OriginTinyIcon",
    "OutlookTinyIcon",
    "OvercastTinyIcon",
    "OverleafTinyIcon",
    "PatreonTinyIcon",
    "PaypalTinyIcon",
    "PdfTinyIcon",
    "PhoneTinyIcon",
    "PhpTinyIcon",
    "PinboardTinyIcon",
    "PinterestTinyIcon",
    "PixelfedTinyIcon",
    "PlexTinyIcon",
    "PocketTinyIcon",
    "PocketcastsTinyIcon",
    "PornhubTinyIcon",
    "PreactTinyIcon",
    "PrintTinyIcon",
    "ProtonmailTinyIcon",
    "PythonTinyIcon",
    "QqTinyIcon",
    "QuoraTinyIcon",
    "Raspberry_piTinyIcon",
    "ReactTinyIcon",
    "RedditTinyIcon",
    "RedhatTinyIcon",
    "ResearchgateTinyIcon",
    "RoundcubeTinyIcon",
    "RssTinyIcon",
    "RubyTinyIcon",
    "RubygemsTinyIcon",
    "RubyonrailsTinyIcon",
    "RustTinyIcon",
    "SafariTinyIcon",
    "SamsungTinyIcon",
    "Samsung_internetTinyIcon",
    "Samsung_sTinyIcon",
    "Samsung_swoopTinyIcon",
    "SassTinyIcon",
    "SemaphoreciTinyIcon",
    "SentryTinyIcon",
    "SignalTinyIcon",
    "SketchTinyIcon",
    "SkypeTinyIcon",
    "SlackTinyIcon",
    "SlideshareTinyIcon",
    "SnapchatTinyIcon",
    "SogoTinyIcon",
    "SoundcloudTinyIcon",
    "SpotifyTinyIcon",
    "Square_cashTinyIcon",
    "StackexchangeTinyIcon",
    "StackoverflowTinyIcon",
    "SteamTinyIcon",
    "StitcherTinyIcon",
    "StravaTinyIcon",
    "StumbleuponTinyIcon",
    "SublimetextTinyIcon",
    "SubscribestarTinyIcon",
    "SvelteTinyIcon",
    "SvgTinyIcon",
    "SymantecTinyIcon",
    "TaigaTinyIcon",
    "TeamspeakTinyIcon",
    "TelegramTinyIcon",
    "TerraformTinyIcon",
    "ThisamericanlifeTinyIcon",
    "ThreemaTinyIcon",
    "TiktokTinyIcon",
    "TodoistTinyIcon",
    "ToxTinyIcon",
    "TrelloTinyIcon",
    "TripadvisorTinyIcon",
    "TumblrTinyIcon",
    "TuneinTinyIcon",
    "TutanotaTinyIcon",
    "TwilioTinyIcon",
    "TwitchTinyIcon",
    "TwitterTinyIcon",
    "TypescriptTinyIcon",
    "UberTinyIcon",
    "UbiquitiTinyIcon",
    "UbisoftTinyIcon",
    "UbuntuTinyIcon",
    "UdemyTinyIcon",
    "UnicodeTinyIcon",
    "UntappdTinyIcon",
    "UpholdTinyIcon",
    "UplayTinyIcon",
    "UpworkTinyIcon",
    "VegetarianTinyIcon",
    "VenmoTinyIcon",
    "ViberTinyIcon",
    "VimeoTinyIcon",
    "VisualstudiocodeTinyIcon",
    "VivinoTinyIcon",
    "VkTinyIcon",
    "VlcTinyIcon",
    "VueTinyIcon",
    "W3cTinyIcon",
    "WebassemblyTinyIcon",
    "WechatTinyIcon",
    "WekanTinyIcon",
    "WhatsappTinyIcon",
    "WhatwgTinyIcon",
    "WifiTinyIcon",
    "WikipediaTinyIcon",
    "WindowsTinyIcon",
    "WireTinyIcon",
    "WireguardTinyIcon",
    "WordpressTinyIcon",
    "WorkatoTinyIcon",
    "XingTinyIcon",
    "XmppTinyIcon",
    "YahooTinyIcon",
    "YammerTinyIcon",
    "YarnTinyIcon",
    "YelpTinyIcon",
    "YoutubeTinyIcon",
    "YubicoTinyIcon",
    "ZoomTinyIcon"
  )
}

#' @title Ionicons
#' @description List of ionicons.
#'
#' @return The names of the ionicons in a vector.
#'
#' @export
#' @details See \href{https://ionic.io/ionicons}{ionicons website}.
#'
#' @examples
#' ionIcons()
ionIcons <- function(){
  c(
    "AccessibilityOutlineIonIcon",
    "AccessibilitySharpIonIcon",
    "AccessibilityIonIcon",
    "AddCircleOutlineIonIcon",
    "AddCircleSharpIonIcon",
    "AddCircleIonIcon",
    "AddOutlineIonIcon",
    "AddSharpIonIcon",
    "AddIonIcon",
    "AirplaneOutlineIonIcon",
    "AirplaneSharpIonIcon",
    "AirplaneIonIcon",
    "AlarmOutlineIonIcon",
    "AlarmSharpIonIcon",
    "AlarmIonIcon",
    "AlbumsOutlineIonIcon",
    "AlbumsSharpIonIcon",
    "AlbumsIonIcon",
    "AlertCircleOutlineIonIcon",
    "AlertCircleSharpIonIcon",
    "AlertCircleIonIcon",
    "AlertOutlineIonIcon",
    "AlertSharpIonIcon",
    "AlertIonIcon",
    "AmericanFootballOutlineIonIcon",
    "AmericanFootballSharpIonIcon",
    "AmericanFootballIonIcon",
    "AnalyticsOutlineIonIcon",
    "AnalyticsSharpIonIcon",
    "AnalyticsIonIcon",
    "ApertureOutlineIonIcon",
    "ApertureSharpIonIcon",
    "ApertureIonIcon",
    "AppsOutlineIonIcon",
    "AppsSharpIonIcon",
    "AppsIonIcon",
    "ArchiveOutlineIonIcon",
    "ArchiveSharpIonIcon",
    "ArchiveIonIcon",
    "ArrowBackCircleOutlineIonIcon",
    "ArrowBackCircleSharpIonIcon",
    "ArrowBackCircleIonIcon",
    "ArrowBackOutlineIonIcon",
    "ArrowBackSharpIonIcon",
    "ArrowBackIonIcon",
    "ArrowDownCircleOutlineIonIcon",
    "ArrowDownCircleSharpIonIcon",
    "ArrowDownCircleIonIcon",
    "ArrowDownOutlineIonIcon",
    "ArrowDownSharpIonIcon",
    "ArrowDownIonIcon",
    "ArrowForwardCircleOutlineIonIcon",
    "ArrowForwardCircleSharpIonIcon",
    "ArrowForwardCircleIonIcon",
    "ArrowForwardOutlineIonIcon",
    "ArrowForwardSharpIonIcon",
    "ArrowForwardIonIcon",
    "ArrowRedoCircleOutlineIonIcon",
    "ArrowRedoCircleSharpIonIcon",
    "ArrowRedoCircleIonIcon",
    "ArrowRedoOutlineIonIcon",
    "ArrowRedoSharpIonIcon",
    "ArrowRedoIonIcon",
    "ArrowUndoCircleOutlineIonIcon",
    "ArrowUndoCircleSharpIonIcon",
    "ArrowUndoCircleIonIcon",
    "ArrowUndoOutlineIonIcon",
    "ArrowUndoSharpIonIcon",
    "ArrowUndoIonIcon",
    "ArrowUpCircleOutlineIonIcon",
    "ArrowUpCircleSharpIonIcon",
    "ArrowUpCircleIonIcon",
    "ArrowUpOutlineIonIcon",
    "ArrowUpSharpIonIcon",
    "ArrowUpIonIcon",
    "AtCircleOutlineIonIcon",
    "AtCircleSharpIonIcon",
    "AtCircleIonIcon",
    "AtOutlineIonIcon",
    "AtSharpIonIcon",
    "AtIonIcon",
    "AttachOutlineIonIcon",
    "AttachSharpIonIcon",
    "AttachIonIcon",
    "BackspaceOutlineIonIcon",
    "BackspaceSharpIonIcon",
    "BackspaceIonIcon",
    "BagAddOutlineIonIcon",
    "BagAddSharpIonIcon",
    "BagAddIonIcon",
    "BagCheckOutlineIonIcon",
    "BagCheckSharpIonIcon",
    "BagCheckIonIcon",
    "BagHandleOutlineIonIcon",
    "BagHandleSharpIonIcon",
    "BagHandleIonIcon",
    "BagOutlineIonIcon",
    "BagRemoveOutlineIonIcon",
    "BagRemoveSharpIonIcon",
    "BagRemoveIonIcon",
    "BagSharpIonIcon",
    "BagIonIcon",
    "BalloonOutlineIonIcon",
    "BalloonSharpIonIcon",
    "BalloonIonIcon",
    "BanOutlineIonIcon",
    "BanSharpIonIcon",
    "BanIonIcon",
    "BandageOutlineIonIcon",
    "BandageSharpIonIcon",
    "BandageIonIcon",
    "BarChartOutlineIonIcon",
    "BarChartSharpIonIcon",
    "BarChartIonIcon",
    "BarbellOutlineIonIcon",
    "BarbellSharpIonIcon",
    "BarbellIonIcon",
    "BarcodeOutlineIonIcon",
    "BarcodeSharpIonIcon",
    "BarcodeIonIcon",
    "BaseballOutlineIonIcon",
    "BaseballSharpIonIcon",
    "BaseballIonIcon",
    "BasketOutlineIonIcon",
    "BasketSharpIonIcon",
    "BasketIonIcon",
    "BasketballOutlineIonIcon",
    "BasketballSharpIonIcon",
    "BasketballIonIcon",
    "BatteryChargingOutlineIonIcon",
    "BatteryChargingSharpIonIcon",
    "BatteryChargingIonIcon",
    "BatteryDeadOutlineIonIcon",
    "BatteryDeadSharpIonIcon",
    "BatteryDeadIonIcon",
    "BatteryFullOutlineIonIcon",
    "BatteryFullSharpIonIcon",
    "BatteryFullIonIcon",
    "BatteryHalfOutlineIonIcon",
    "BatteryHalfSharpIonIcon",
    "BatteryHalfIonIcon",
    "BeakerOutlineIonIcon",
    "BeakerSharpIonIcon",
    "BeakerIonIcon",
    "BedOutlineIonIcon",
    "BedSharpIonIcon",
    "BedIonIcon",
    "BeerOutlineIonIcon",
    "BeerSharpIonIcon",
    "BeerIonIcon",
    "BicycleOutlineIonIcon",
    "BicycleSharpIonIcon",
    "BicycleIonIcon",
    "BluetoothOutlineIonIcon",
    "BluetoothSharpIonIcon",
    "BluetoothIonIcon",
    "BoatOutlineIonIcon",
    "BoatSharpIonIcon",
    "BoatIonIcon",
    "BodyOutlineIonIcon",
    "BodySharpIonIcon",
    "BodyIonIcon",
    "BonfireOutlineIonIcon",
    "BonfireSharpIonIcon",
    "BonfireIonIcon",
    "BookOutlineIonIcon",
    "BookSharpIonIcon",
    "BookIonIcon",
    "BookmarkOutlineIonIcon",
    "BookmarkSharpIonIcon",
    "BookmarkIonIcon",
    "BookmarksOutlineIonIcon",
    "BookmarksSharpIonIcon",
    "BookmarksIonIcon",
    "BowlingBallOutlineIonIcon",
    "BowlingBallSharpIonIcon",
    "BowlingBallIonIcon",
    "BriefcaseOutlineIonIcon",
    "BriefcaseSharpIonIcon",
    "BriefcaseIonIcon",
    "BrowsersOutlineIonIcon",
    "BrowsersSharpIonIcon",
    "BrowsersIonIcon",
    "BrushOutlineIonIcon",
    "BrushSharpIonIcon",
    "BrushIonIcon",
    "BugOutlineIonIcon",
    "BugSharpIonIcon",
    "BugIonIcon",
    "BuildOutlineIonIcon",
    "BuildSharpIonIcon",
    "BuildIonIcon",
    "BulbOutlineIonIcon",
    "BulbSharpIonIcon",
    "BulbIonIcon",
    "BusOutlineIonIcon",
    "BusSharpIonIcon",
    "BusIonIcon",
    "BusinessOutlineIonIcon",
    "BusinessSharpIonIcon",
    "BusinessIonIcon",
    "CafeOutlineIonIcon",
    "CafeSharpIonIcon",
    "CafeIonIcon",
    "CalculatorOutlineIonIcon",
    "CalculatorSharpIonIcon",
    "CalculatorIonIcon",
    "CalendarClearOutlineIonIcon",
    "CalendarClearSharpIonIcon",
    "CalendarClearIonIcon",
    "CalendarNumberOutlineIonIcon",
    "CalendarNumberSharpIonIcon",
    "CalendarNumberIonIcon",
    "CalendarOutlineIonIcon",
    "CalendarSharpIonIcon",
    "CalendarIonIcon",
    "CallOutlineIonIcon",
    "CallSharpIonIcon",
    "CallIonIcon",
    "CameraOutlineIonIcon",
    "CameraReverseOutlineIonIcon",
    "CameraReverseSharpIonIcon",
    "CameraReverseIonIcon",
    "CameraSharpIonIcon",
    "CameraIonIcon",
    "CarOutlineIonIcon",
    "CarSharpIonIcon",
    "CarSportOutlineIonIcon",
    "CarSportSharpIonIcon",
    "CarSportIonIcon",
    "CarIonIcon",
    "CardOutlineIonIcon",
    "CardSharpIonIcon",
    "CardIonIcon",
    "CaretBackCircleOutlineIonIcon",
    "CaretBackCircleSharpIonIcon",
    "CaretBackCircleIonIcon",
    "CaretBackOutlineIonIcon",
    "CaretBackSharpIonIcon",
    "CaretBackIonIcon",
    "CaretDownCircleOutlineIonIcon",
    "CaretDownCircleSharpIonIcon",
    "CaretDownCircleIonIcon",
    "CaretDownOutlineIonIcon",
    "CaretDownSharpIonIcon",
    "CaretDownIonIcon",
    "CaretForwardCircleOutlineIonIcon",
    "CaretForwardCircleSharpIonIcon",
    "CaretForwardCircleIonIcon",
    "CaretForwardOutlineIonIcon",
    "CaretForwardSharpIonIcon",
    "CaretForwardIonIcon",
    "CaretUpCircleOutlineIonIcon",
    "CaretUpCircleSharpIonIcon",
    "CaretUpCircleIonIcon",
    "CaretUpOutlineIonIcon",
    "CaretUpSharpIonIcon",
    "CaretUpIonIcon",
    "CartOutlineIonIcon",
    "CartSharpIonIcon",
    "CartIonIcon",
    "CashOutlineIonIcon",
    "CashSharpIonIcon",
    "CashIonIcon",
    "CellularOutlineIonIcon",
    "CellularSharpIonIcon",
    "CellularIonIcon",
    "ChatboxEllipsesOutlineIonIcon",
    "ChatboxEllipsesSharpIonIcon",
    "ChatboxEllipsesIonIcon",
    "ChatboxOutlineIonIcon",
    "ChatboxSharpIonIcon",
    "ChatboxIonIcon",
    "ChatbubbleEllipsesOutlineIonIcon",
    "ChatbubbleEllipsesSharpIonIcon",
    "ChatbubbleEllipsesIonIcon",
    "ChatbubbleOutlineIonIcon",
    "ChatbubbleSharpIonIcon",
    "ChatbubbleIonIcon",
    "ChatbubblesOutlineIonIcon",
    "ChatbubblesSharpIonIcon",
    "ChatbubblesIonIcon",
    "CheckboxOutlineIonIcon",
    "CheckboxSharpIonIcon",
    "CheckboxIonIcon",
    "CheckmarkCircleOutlineIonIcon",
    "CheckmarkCircleSharpIonIcon",
    "CheckmarkCircleIonIcon",
    "CheckmarkDoneCircleOutlineIonIcon",
    "CheckmarkDoneCircleSharpIonIcon",
    "CheckmarkDoneCircleIonIcon",
    "CheckmarkDoneOutlineIonIcon",
    "CheckmarkDoneSharpIonIcon",
    "CheckmarkDoneIonIcon",
    "CheckmarkOutlineIonIcon",
    "CheckmarkSharpIonIcon",
    "CheckmarkIonIcon",
    "ChevronBackCircleOutlineIonIcon",
    "ChevronBackCircleSharpIonIcon",
    "ChevronBackCircleIonIcon",
    "ChevronBackOutlineIonIcon",
    "ChevronBackSharpIonIcon",
    "ChevronBackIonIcon",
    "ChevronDownCircleOutlineIonIcon",
    "ChevronDownCircleSharpIonIcon",
    "ChevronDownCircleIonIcon",
    "ChevronDownOutlineIonIcon",
    "ChevronDownSharpIonIcon",
    "ChevronDownIonIcon",
    "ChevronForwardCircleOutlineIonIcon",
    "ChevronForwardCircleSharpIonIcon",
    "ChevronForwardCircleIonIcon",
    "ChevronForwardOutlineIonIcon",
    "ChevronForwardSharpIonIcon",
    "ChevronForwardIonIcon",
    "ChevronUpCircleOutlineIonIcon",
    "ChevronUpCircleSharpIonIcon",
    "ChevronUpCircleIonIcon",
    "ChevronUpOutlineIonIcon",
    "ChevronUpSharpIonIcon",
    "ChevronUpIonIcon",
    "ClipboardOutlineIonIcon",
    "ClipboardSharpIonIcon",
    "ClipboardIonIcon",
    "CloseCircleOutlineIonIcon",
    "CloseCircleSharpIonIcon",
    "CloseCircleIonIcon",
    "CloseOutlineIonIcon",
    "CloseSharpIonIcon",
    "CloseIonIcon",
    "CloudCircleOutlineIonIcon",
    "CloudCircleSharpIonIcon",
    "CloudCircleIonIcon",
    "CloudDoneOutlineIonIcon",
    "CloudDoneSharpIonIcon",
    "CloudDoneIonIcon",
    "CloudDownloadOutlineIonIcon",
    "CloudDownloadSharpIonIcon",
    "CloudDownloadIonIcon",
    "CloudOfflineOutlineIonIcon",
    "CloudOfflineSharpIonIcon",
    "CloudOfflineIonIcon",
    "CloudOutlineIonIcon",
    "CloudSharpIonIcon",
    "CloudUploadOutlineIonIcon",
    "CloudUploadSharpIonIcon",
    "CloudUploadIonIcon",
    "CloudIonIcon",
    "CloudyNightOutlineIonIcon",
    "CloudyNightSharpIonIcon",
    "CloudyNightIonIcon",
    "CloudyOutlineIonIcon",
    "CloudySharpIonIcon",
    "CloudyIonIcon",
    "CodeDownloadOutlineIonIcon",
    "CodeDownloadSharpIonIcon",
    "CodeDownloadIonIcon",
    "CodeOutlineIonIcon",
    "CodeSharpIonIcon",
    "CodeSlashOutlineIonIcon",
    "CodeSlashSharpIonIcon",
    "CodeSlashIonIcon",
    "CodeWorkingOutlineIonIcon",
    "CodeWorkingSharpIonIcon",
    "CodeWorkingIonIcon",
    "CodeIonIcon",
    "CogOutlineIonIcon",
    "CogSharpIonIcon",
    "CogIonIcon",
    "ColorFillOutlineIonIcon",
    "ColorFillSharpIonIcon",
    "ColorFillIonIcon",
    "ColorFilterOutlineIonIcon",
    "ColorFilterSharpIonIcon",
    "ColorFilterIonIcon",
    "ColorPaletteOutlineIonIcon",
    "ColorPaletteSharpIonIcon",
    "ColorPaletteIonIcon",
    "ColorWandOutlineIonIcon",
    "ColorWandSharpIonIcon",
    "ColorWandIonIcon",
    "CompassOutlineIonIcon",
    "CompassSharpIonIcon",
    "CompassIonIcon",
    "ConstructOutlineIonIcon",
    "ConstructSharpIonIcon",
    "ConstructIonIcon",
    "ContractOutlineIonIcon",
    "ContractSharpIonIcon",
    "ContractIonIcon",
    "ContrastOutlineIonIcon",
    "ContrastSharpIonIcon",
    "ContrastIonIcon",
    "CopyOutlineIonIcon",
    "CopySharpIonIcon",
    "CopyIonIcon",
    "CreateOutlineIonIcon",
    "CreateSharpIonIcon",
    "CreateIonIcon",
    "CropOutlineIonIcon",
    "CropSharpIonIcon",
    "CropIonIcon",
    "CubeOutlineIonIcon",
    "CubeSharpIonIcon",
    "CubeIonIcon",
    "CutOutlineIonIcon",
    "CutSharpIonIcon",
    "CutIonIcon",
    "DesktopOutlineIonIcon",
    "DesktopSharpIonIcon",
    "DesktopIonIcon",
    "DiamondOutlineIonIcon",
    "DiamondSharpIonIcon",
    "DiamondIonIcon",
    "DiceOutlineIonIcon",
    "DiceSharpIonIcon",
    "DiceIonIcon",
    "DiscOutlineIonIcon",
    "DiscSharpIonIcon",
    "DiscIonIcon",
    "DocumentAttachOutlineIonIcon",
    "DocumentAttachSharpIonIcon",
    "DocumentAttachIonIcon",
    "DocumentLockOutlineIonIcon",
    "DocumentLockSharpIonIcon",
    "DocumentLockIonIcon",
    "DocumentOutlineIonIcon",
    "DocumentSharpIonIcon",
    "DocumentTextOutlineIonIcon",
    "DocumentTextSharpIonIcon",
    "DocumentTextIonIcon",
    "DocumentIonIcon",
    "DocumentsOutlineIonIcon",
    "DocumentsSharpIonIcon",
    "DocumentsIonIcon",
    "DownloadOutlineIonIcon",
    "DownloadSharpIonIcon",
    "DownloadIonIcon",
    "DuplicateOutlineIonIcon",
    "DuplicateSharpIonIcon",
    "DuplicateIonIcon",
    "EarOutlineIonIcon",
    "EarSharpIonIcon",
    "EarIonIcon",
    "EarthOutlineIonIcon",
    "EarthSharpIonIcon",
    "EarthIonIcon",
    "EaselOutlineIonIcon",
    "EaselSharpIonIcon",
    "EaselIonIcon",
    "EggOutlineIonIcon",
    "EggSharpIonIcon",
    "EggIonIcon",
    "EllipseOutlineIonIcon",
    "EllipseSharpIonIcon",
    "EllipseIonIcon",
    "EllipsisHorizontalCircleOutlineIonIcon",
    "EllipsisHorizontalCircleSharpIonIcon",
    "EllipsisHorizontalCircleIonIcon",
    "EllipsisHorizontalOutlineIonIcon",
    "EllipsisHorizontalSharpIonIcon",
    "EllipsisHorizontalIonIcon",
    "EllipsisVerticalCircleOutlineIonIcon",
    "EllipsisVerticalCircleSharpIonIcon",
    "EllipsisVerticalCircleIonIcon",
    "EllipsisVerticalOutlineIonIcon",
    "EllipsisVerticalSharpIonIcon",
    "EllipsisVerticalIonIcon",
    "EnterOutlineIonIcon",
    "EnterSharpIonIcon",
    "EnterIonIcon",
    "ExitOutlineIonIcon",
    "ExitSharpIonIcon",
    "ExitIonIcon",
    "ExpandOutlineIonIcon",
    "ExpandSharpIonIcon",
    "ExpandIonIcon",
    "ExtensionPuzzleOutlineIonIcon",
    "ExtensionPuzzleSharpIonIcon",
    "ExtensionPuzzleIonIcon",
    "EyeOffOutlineIonIcon",
    "EyeOffSharpIonIcon",
    "EyeOffIonIcon",
    "EyeOutlineIonIcon",
    "EyeSharpIonIcon",
    "EyeIonIcon",
    "EyedropOutlineIonIcon",
    "EyedropSharpIonIcon",
    "EyedropIonIcon",
    "FastFoodOutlineIonIcon",
    "FastFoodSharpIonIcon",
    "FastFoodIonIcon",
    "FemaleOutlineIonIcon",
    "FemaleSharpIonIcon",
    "FemaleIonIcon",
    "FileTrayFullOutlineIonIcon",
    "FileTrayFullSharpIonIcon",
    "FileTrayFullIonIcon",
    "FileTrayOutlineIonIcon",
    "FileTraySharpIonIcon",
    "FileTrayStackedOutlineIonIcon",
    "FileTrayStackedSharpIonIcon",
    "FileTrayStackedIonIcon",
    "FileTrayIonIcon",
    "FilmOutlineIonIcon",
    "FilmSharpIonIcon",
    "FilmIonIcon",
    "FilterCircleOutlineIonIcon",
    "FilterCircleSharpIonIcon",
    "FilterCircleIonIcon",
    "FilterOutlineIonIcon",
    "FilterSharpIonIcon",
    "FilterIonIcon",
    "FingerPrintOutlineIonIcon",
    "FingerPrintSharpIonIcon",
    "FingerPrintIonIcon",
    "FishOutlineIonIcon",
    "FishSharpIonIcon",
    "FishIonIcon",
    "FitnessOutlineIonIcon",
    "FitnessSharpIonIcon",
    "FitnessIonIcon",
    "FlagOutlineIonIcon",
    "FlagSharpIonIcon",
    "FlagIonIcon",
    "FlameOutlineIonIcon",
    "FlameSharpIonIcon",
    "FlameIonIcon",
    "FlashOffOutlineIonIcon",
    "FlashOffSharpIonIcon",
    "FlashOffIonIcon",
    "FlashOutlineIonIcon",
    "FlashSharpIonIcon",
    "FlashIonIcon",
    "FlashlightOutlineIonIcon",
    "FlashlightSharpIonIcon",
    "FlashlightIonIcon",
    "FlaskOutlineIonIcon",
    "FlaskSharpIonIcon",
    "FlaskIonIcon",
    "FlowerOutlineIonIcon",
    "FlowerSharpIonIcon",
    "FlowerIonIcon",
    "FolderOpenOutlineIonIcon",
    "FolderOpenSharpIonIcon",
    "FolderOpenIonIcon",
    "FolderOutlineIonIcon",
    "FolderSharpIonIcon",
    "FolderIonIcon",
    "FootballOutlineIonIcon",
    "FootballSharpIonIcon",
    "FootballIonIcon",
    "FootstepsOutlineIonIcon",
    "FootstepsSharpIonIcon",
    "FootstepsIonIcon",
    "FunnelOutlineIonIcon",
    "FunnelSharpIonIcon",
    "FunnelIonIcon",
    "GameControllerOutlineIonIcon",
    "GameControllerSharpIonIcon",
    "GameControllerIonIcon",
    "GiftOutlineIonIcon",
    "GiftSharpIonIcon",
    "GiftIonIcon",
    "GitBranchOutlineIonIcon",
    "GitBranchSharpIonIcon",
    "GitBranchIonIcon",
    "GitCommitOutlineIonIcon",
    "GitCommitSharpIonIcon",
    "GitCommitIonIcon",
    "GitCompareOutlineIonIcon",
    "GitCompareSharpIonIcon",
    "GitCompareIonIcon",
    "GitMergeOutlineIonIcon",
    "GitMergeSharpIonIcon",
    "GitMergeIonIcon",
    "GitNetworkOutlineIonIcon",
    "GitNetworkSharpIonIcon",
    "GitNetworkIonIcon",
    "GitPullRequestOutlineIonIcon",
    "GitPullRequestSharpIonIcon",
    "GitPullRequestIonIcon",
    "GlassesOutlineIonIcon",
    "GlassesSharpIonIcon",
    "GlassesIonIcon",
    "GlobeOutlineIonIcon",
    "GlobeSharpIonIcon",
    "GlobeIonIcon",
    "GolfOutlineIonIcon",
    "GolfSharpIonIcon",
    "GolfIonIcon",
    "GridOutlineIonIcon",
    "GridSharpIonIcon",
    "GridIonIcon",
    "HammerOutlineIonIcon",
    "HammerSharpIonIcon",
    "HammerIonIcon",
    "HandLeftOutlineIonIcon",
    "HandLeftSharpIonIcon",
    "HandLeftIonIcon",
    "HandRightOutlineIonIcon",
    "HandRightSharpIonIcon",
    "HandRightIonIcon",
    "HappyOutlineIonIcon",
    "HappySharpIonIcon",
    "HappyIonIcon",
    "HardwareChipOutlineIonIcon",
    "HardwareChipSharpIonIcon",
    "HardwareChipIonIcon",
    "HeadsetOutlineIonIcon",
    "HeadsetSharpIonIcon",
    "HeadsetIonIcon",
    "HeartCircleOutlineIonIcon",
    "HeartCircleSharpIonIcon",
    "HeartCircleIonIcon",
    "HeartDislikeCircleOutlineIonIcon",
    "HeartDislikeCircleSharpIonIcon",
    "HeartDislikeCircleIonIcon",
    "HeartDislikeOutlineIonIcon",
    "HeartDislikeSharpIonIcon",
    "HeartDislikeIonIcon",
    "HeartHalfOutlineIonIcon",
    "HeartHalfSharpIonIcon",
    "HeartHalfIonIcon",
    "HeartOutlineIonIcon",
    "HeartSharpIonIcon",
    "HeartIonIcon",
    "HelpBuoyOutlineIonIcon",
    "HelpBuoySharpIonIcon",
    "HelpBuoyIonIcon",
    "HelpCircleOutlineIonIcon",
    "HelpCircleSharpIonIcon",
    "HelpCircleIonIcon",
    "HelpOutlineIonIcon",
    "HelpSharpIonIcon",
    "HelpIonIcon",
    "HomeOutlineIonIcon",
    "HomeSharpIonIcon",
    "HomeIonIcon",
    "HourglassOutlineIonIcon",
    "HourglassSharpIonIcon",
    "HourglassIonIcon",
    "IceCreamOutlineIonIcon",
    "IceCreamSharpIonIcon",
    "IceCreamIonIcon",
    "IdCardOutlineIonIcon",
    "IdCardSharpIonIcon",
    "IdCardIonIcon",
    "ImageOutlineIonIcon",
    "ImageSharpIonIcon",
    "ImageIonIcon",
    "ImagesOutlineIonIcon",
    "ImagesSharpIonIcon",
    "ImagesIonIcon",
    "InfiniteOutlineIonIcon",
    "InfiniteSharpIonIcon",
    "InfiniteIonIcon",
    "InformationCircleOutlineIonIcon",
    "InformationCircleSharpIonIcon",
    "InformationCircleIonIcon",
    "InformationOutlineIonIcon",
    "InformationSharpIonIcon",
    "InformationIonIcon",
    "InvertModeOutlineIonIcon",
    "InvertModeSharpIonIcon",
    "InvertModeIonIcon",
    "JournalOutlineIonIcon",
    "JournalSharpIonIcon",
    "JournalIonIcon",
    "KeyOutlineIonIcon",
    "KeySharpIonIcon",
    "KeyIonIcon",
    "KeypadOutlineIonIcon",
    "KeypadSharpIonIcon",
    "KeypadIonIcon",
    "LanguageOutlineIonIcon",
    "LanguageSharpIonIcon",
    "LanguageIonIcon",
    "LaptopOutlineIonIcon",
    "LaptopSharpIonIcon",
    "LaptopIonIcon",
    "LayersOutlineIonIcon",
    "LayersSharpIonIcon",
    "LayersIonIcon",
    "LeafOutlineIonIcon",
    "LeafSharpIonIcon",
    "LeafIonIcon",
    "LibraryOutlineIonIcon",
    "LibrarySharpIonIcon",
    "LibraryIonIcon",
    "LinkOutlineIonIcon",
    "LinkSharpIonIcon",
    "LinkIonIcon",
    "ListCircleOutlineIonIcon",
    "ListCircleSharpIonIcon",
    "ListCircleIonIcon",
    "ListOutlineIonIcon",
    "ListSharpIonIcon",
    "ListIonIcon",
    "LocateOutlineIonIcon",
    "LocateSharpIonIcon",
    "LocateIonIcon",
    "LocationOutlineIonIcon",
    "LocationSharpIonIcon",
    "LocationIonIcon",
    "LockClosedOutlineIonIcon",
    "LockClosedSharpIonIcon",
    "LockClosedIonIcon",
    "LockOpenOutlineIonIcon",
    "LockOpenSharpIonIcon",
    "LockOpenIonIcon",
    "LogInOutlineIonIcon",
    "LogInSharpIonIcon",
    "LogInIonIcon",
    "LogOutOutlineIonIcon",
    "LogOutSharpIonIcon",
    "LogOutIonIcon",
    "LogoAlipayIonIcon",
    "LogoAmazonIonIcon",
    "LogoAmplifyIonIcon",
    "LogoAndroidIonIcon",
    "LogoAngularIonIcon",
    "LogoAppleAppstoreIonIcon",
    "LogoAppleArIonIcon",
    "LogoAppleIonIcon",
    "LogoBehanceIonIcon",
    "LogoBitbucketIonIcon",
    "LogoBitcoinIonIcon",
    "LogoBufferIonIcon",
    "LogoCapacitorIonIcon",
    "LogoChromeIonIcon",
    "LogoClosedCaptioningIonIcon",
    "LogoCodepenIonIcon",
    "LogoCss3IonIcon",
    "LogoDesignernewsIonIcon",
    "LogoDeviantartIonIcon",
    "LogoDiscordIonIcon",
    "LogoDockerIonIcon",
    "LogoDribbbleIonIcon",
    "LogoDropboxIonIcon",
    "LogoEdgeIonIcon",
    "LogoElectronIonIcon",
    "LogoEuroIonIcon",
    "LogoFacebookIonIcon",
    "LogoFigmaIonIcon",
    "LogoFirebaseIonIcon",
    "LogoFirefoxIonIcon",
    "LogoFlickrIonIcon",
    "LogoFoursquareIonIcon",
    "LogoGithubIonIcon",
    "LogoGitlabIonIcon",
    "LogoGooglePlaystoreIonIcon",
    "LogoGoogleIonIcon",
    "LogoHackernewsIonIcon",
    "LogoHtml5IonIcon",
    "LogoInstagramIonIcon",
    "LogoIonicIonIcon",
    "LogoIonitronIonIcon",
    "LogoJavascriptIonIcon",
    "LogoLaravelIonIcon",
    "LogoLinkedinIonIcon",
    "LogoMarkdownIonIcon",
    "LogoMastodonIonIcon",
    "LogoMediumIonIcon",
    "LogoMicrosoftIonIcon",
    "LogoNoSmokingIonIcon",
    "LogoNodejsIonIcon",
    "LogoNpmIonIcon",
    "LogoOctocatIonIcon",
    "LogoPaypalIonIcon",
    "LogoPinterestIonIcon",
    "LogoPlaystationIonIcon",
    "LogoPwaIonIcon",
    "LogoPythonIonIcon",
    "LogoReactIonIcon",
    "LogoRedditIonIcon",
    "LogoRssIonIcon",
    "LogoSassIonIcon",
    "LogoSkypeIonIcon",
    "LogoSlackIonIcon",
    "LogoSnapchatIonIcon",
    "LogoSoundcloudIonIcon",
    "LogoStackoverflowIonIcon",
    "LogoSteamIonIcon",
    "LogoStencilIonIcon",
    "LogoTableauIonIcon",
    "LogoTiktokIonIcon",
    "LogoTumblrIonIcon",
    "LogoTuxIonIcon",
    "LogoTwitchIonIcon",
    "LogoTwitterIonIcon",
    "LogoUsdIonIcon",
    "LogoVenmoIonIcon",
    "LogoVercelIonIcon",
    "LogoVimeoIonIcon",
    "LogoVkIonIcon",
    "LogoVueIonIcon",
    "LogoWebComponentIonIcon",
    "LogoWechatIonIcon",
    "LogoWhatsappIonIcon",
    "LogoWindowsIonIcon",
    "LogoWordpressIonIcon",
    "LogoXboxIonIcon",
    "LogoXingIonIcon",
    "LogoYahooIonIcon",
    "LogoYenIonIcon",
    "LogoYoutubeIonIcon",
    "MagnetOutlineIonIcon",
    "MagnetSharpIonIcon",
    "MagnetIonIcon",
    "MailOpenOutlineIonIcon",
    "MailOpenSharpIonIcon",
    "MailOpenIonIcon",
    "MailOutlineIonIcon",
    "MailSharpIonIcon",
    "MailUnreadOutlineIonIcon",
    "MailUnreadSharpIonIcon",
    "MailUnreadIonIcon",
    "MailIonIcon",
    "MaleFemaleOutlineIonIcon",
    "MaleFemaleSharpIonIcon",
    "MaleFemaleIonIcon",
    "MaleOutlineIonIcon",
    "MaleSharpIonIcon",
    "MaleIonIcon",
    "ManOutlineIonIcon",
    "ManSharpIonIcon",
    "ManIonIcon",
    "MapOutlineIonIcon",
    "MapSharpIonIcon",
    "MapIonIcon",
    "MedalOutlineIonIcon",
    "MedalSharpIonIcon",
    "MedalIonIcon",
    "MedicalOutlineIonIcon",
    "MedicalSharpIonIcon",
    "MedicalIonIcon",
    "MedkitOutlineIonIcon",
    "MedkitSharpIonIcon",
    "MedkitIonIcon",
    "MegaphoneOutlineIonIcon",
    "MegaphoneSharpIonIcon",
    "MegaphoneIonIcon",
    "MenuOutlineIonIcon",
    "MenuSharpIonIcon",
    "MenuIonIcon",
    "MicCircleOutlineIonIcon",
    "MicCircleSharpIonIcon",
    "MicCircleIonIcon",
    "MicOffCircleOutlineIonIcon",
    "MicOffCircleSharpIonIcon",
    "MicOffCircleIonIcon",
    "MicOffOutlineIonIcon",
    "MicOffSharpIonIcon",
    "MicOffIonIcon",
    "MicOutlineIonIcon",
    "MicSharpIonIcon",
    "MicIonIcon",
    "MoonOutlineIonIcon",
    "MoonSharpIonIcon",
    "MoonIonIcon",
    "MoveOutlineIonIcon",
    "MoveSharpIonIcon",
    "MoveIonIcon",
    "MusicalNoteOutlineIonIcon",
    "MusicalNoteSharpIonIcon",
    "MusicalNoteIonIcon",
    "MusicalNotesOutlineIonIcon",
    "MusicalNotesSharpIonIcon",
    "MusicalNotesIonIcon",
    "NavigateCircleOutlineIonIcon",
    "NavigateCircleSharpIonIcon",
    "NavigateCircleIonIcon",
    "NavigateOutlineIonIcon",
    "NavigateSharpIonIcon",
    "NavigateIonIcon",
    "NewspaperOutlineIonIcon",
    "NewspaperSharpIonIcon",
    "NewspaperIonIcon",
    "NotificationsCircleOutlineIonIcon",
    "NotificationsCircleSharpIonIcon",
    "NotificationsCircleIonIcon",
    "NotificationsOffCircleOutlineIonIcon",
    "NotificationsOffCircleSharpIonIcon",
    "NotificationsOffCircleIonIcon",
    "NotificationsOffOutlineIonIcon",
    "NotificationsOffSharpIonIcon",
    "NotificationsOffIonIcon",
    "NotificationsOutlineIonIcon",
    "NotificationsSharpIonIcon",
    "NotificationsIonIcon",
    "NuclearOutlineIonIcon",
    "NuclearSharpIonIcon",
    "NuclearIonIcon",
    "NutritionOutlineIonIcon",
    "NutritionSharpIonIcon",
    "NutritionIonIcon",
    "OpenOutlineIonIcon",
    "OpenSharpIonIcon",
    "OpenIonIcon",
    "OptionsOutlineIonIcon",
    "OptionsSharpIonIcon",
    "OptionsIonIcon",
    "PaperPlaneOutlineIonIcon",
    "PaperPlaneSharpIonIcon",
    "PaperPlaneIonIcon",
    "PartlySunnyOutlineIonIcon",
    "PartlySunnySharpIonIcon",
    "PartlySunnyIonIcon",
    "PauseCircleOutlineIonIcon",
    "PauseCircleSharpIonIcon",
    "PauseCircleIonIcon",
    "PauseOutlineIonIcon",
    "PauseSharpIonIcon",
    "PauseIonIcon",
    "PawOutlineIonIcon",
    "PawSharpIonIcon",
    "PawIonIcon",
    "PencilOutlineIonIcon",
    "PencilSharpIonIcon",
    "PencilIonIcon",
    "PeopleCircleOutlineIonIcon",
    "PeopleCircleSharpIonIcon",
    "PeopleCircleIonIcon",
    "PeopleOutlineIonIcon",
    "PeopleSharpIonIcon",
    "PeopleIonIcon",
    "PersonAddOutlineIonIcon",
    "PersonAddSharpIonIcon",
    "PersonAddIonIcon",
    "PersonCircleOutlineIonIcon",
    "PersonCircleSharpIonIcon",
    "PersonCircleIonIcon",
    "PersonOutlineIonIcon",
    "PersonRemoveOutlineIonIcon",
    "PersonRemoveSharpIonIcon",
    "PersonRemoveIonIcon",
    "PersonSharpIonIcon",
    "PersonIonIcon",
    "PhoneLandscapeOutlineIonIcon",
    "PhoneLandscapeSharpIonIcon",
    "PhoneLandscapeIonIcon",
    "PhonePortraitOutlineIonIcon",
    "PhonePortraitSharpIonIcon",
    "PhonePortraitIonIcon",
    "PieChartOutlineIonIcon",
    "PieChartSharpIonIcon",
    "PieChartIonIcon",
    "PinOutlineIonIcon",
    "PinSharpIonIcon",
    "PinIonIcon",
    "PintOutlineIonIcon",
    "PintSharpIonIcon",
    "PintIonIcon",
    "PizzaOutlineIonIcon",
    "PizzaSharpIonIcon",
    "PizzaIonIcon",
    "PlanetOutlineIonIcon",
    "PlanetSharpIonIcon",
    "PlanetIonIcon",
    "PlayBackCircleOutlineIonIcon",
    "PlayBackCircleSharpIonIcon",
    "PlayBackCircleIonIcon",
    "PlayBackOutlineIonIcon",
    "PlayBackSharpIonIcon",
    "PlayBackIonIcon",
    "PlayCircleOutlineIonIcon",
    "PlayCircleSharpIonIcon",
    "PlayCircleIonIcon",
    "PlayForwardCircleOutlineIonIcon",
    "PlayForwardCircleSharpIonIcon",
    "PlayForwardCircleIonIcon",
    "PlayForwardOutlineIonIcon",
    "PlayForwardSharpIonIcon",
    "PlayForwardIonIcon",
    "PlayOutlineIonIcon",
    "PlaySharpIonIcon",
    "PlaySkipBackCircleOutlineIonIcon",
    "PlaySkipBackCircleSharpIonIcon",
    "PlaySkipBackCircleIonIcon",
    "PlaySkipBackOutlineIonIcon",
    "PlaySkipBackSharpIonIcon",
    "PlaySkipBackIonIcon",
    "PlaySkipForwardCircleOutlineIonIcon",
    "PlaySkipForwardCircleSharpIonIcon",
    "PlaySkipForwardCircleIonIcon",
    "PlaySkipForwardOutlineIonIcon",
    "PlaySkipForwardSharpIonIcon",
    "PlaySkipForwardIonIcon",
    "PlayIonIcon",
    "PodiumOutlineIonIcon",
    "PodiumSharpIonIcon",
    "PodiumIonIcon",
    "PowerOutlineIonIcon",
    "PowerSharpIonIcon",
    "PowerIonIcon",
    "PricetagOutlineIonIcon",
    "PricetagSharpIonIcon",
    "PricetagIonIcon",
    "PricetagsOutlineIonIcon",
    "PricetagsSharpIonIcon",
    "PricetagsIonIcon",
    "PrintOutlineIonIcon",
    "PrintSharpIonIcon",
    "PrintIonIcon",
    "PrismOutlineIonIcon",
    "PrismSharpIonIcon",
    "PrismIonIcon",
    "PulseOutlineIonIcon",
    "PulseSharpIonIcon",
    "PulseIonIcon",
    "PushOutlineIonIcon",
    "PushSharpIonIcon",
    "PushIonIcon",
    "QrCodeOutlineIonIcon",
    "QrCodeSharpIonIcon",
    "QrCodeIonIcon",
    "RadioButtonOffOutlineIonIcon",
    "RadioButtonOffSharpIonIcon",
    "RadioButtonOffIonIcon",
    "RadioButtonOnOutlineIonIcon",
    "RadioButtonOnSharpIonIcon",
    "RadioButtonOnIonIcon",
    "RadioOutlineIonIcon",
    "RadioSharpIonIcon",
    "RadioIonIcon",
    "RainyOutlineIonIcon",
    "RainySharpIonIcon",
    "RainyIonIcon",
    "ReaderOutlineIonIcon",
    "ReaderSharpIonIcon",
    "ReaderIonIcon",
    "ReceiptOutlineIonIcon",
    "ReceiptSharpIonIcon",
    "ReceiptIonIcon",
    "RecordingOutlineIonIcon",
    "RecordingSharpIonIcon",
    "RecordingIonIcon",
    "RefreshCircleOutlineIonIcon",
    "RefreshCircleSharpIonIcon",
    "RefreshCircleIonIcon",
    "RefreshOutlineIonIcon",
    "RefreshSharpIonIcon",
    "RefreshIonIcon",
    "ReloadCircleOutlineIonIcon",
    "ReloadCircleSharpIonIcon",
    "ReloadCircleIonIcon",
    "ReloadOutlineIonIcon",
    "ReloadSharpIonIcon",
    "ReloadIonIcon",
    "RemoveCircleOutlineIonIcon",
    "RemoveCircleSharpIonIcon",
    "RemoveCircleIonIcon",
    "RemoveOutlineIonIcon",
    "RemoveSharpIonIcon",
    "RemoveIonIcon",
    "ReorderFourOutlineIonIcon",
    "ReorderFourSharpIonIcon",
    "ReorderFourIonIcon",
    "ReorderThreeOutlineIonIcon",
    "ReorderThreeSharpIonIcon",
    "ReorderThreeIonIcon",
    "ReorderTwoOutlineIonIcon",
    "ReorderTwoSharpIonIcon",
    "ReorderTwoIonIcon",
    "RepeatOutlineIonIcon",
    "RepeatSharpIonIcon",
    "RepeatIonIcon",
    "ResizeOutlineIonIcon",
    "ResizeSharpIonIcon",
    "ResizeIonIcon",
    "RestaurantOutlineIonIcon",
    "RestaurantSharpIonIcon",
    "RestaurantIonIcon",
    "ReturnDownBackOutlineIonIcon",
    "ReturnDownBackSharpIonIcon",
    "ReturnDownBackIonIcon",
    "ReturnDownForwardOutlineIonIcon",
    "ReturnDownForwardSharpIonIcon",
    "ReturnDownForwardIonIcon",
    "ReturnUpBackOutlineIonIcon",
    "ReturnUpBackSharpIonIcon",
    "ReturnUpBackIonIcon",
    "ReturnUpForwardOutlineIonIcon",
    "ReturnUpForwardSharpIonIcon",
    "ReturnUpForwardIonIcon",
    "RibbonOutlineIonIcon",
    "RibbonSharpIonIcon",
    "RibbonIonIcon",
    "RocketOutlineIonIcon",
    "RocketSharpIonIcon",
    "RocketIonIcon",
    "RoseOutlineIonIcon",
    "RoseSharpIonIcon",
    "RoseIonIcon",
    "SadOutlineIonIcon",
    "SadSharpIonIcon",
    "SadIonIcon",
    "SaveOutlineIonIcon",
    "SaveSharpIonIcon",
    "SaveIonIcon",
    "ScaleOutlineIonIcon",
    "ScaleSharpIonIcon",
    "ScaleIonIcon",
    "ScanCircleOutlineIonIcon",
    "ScanCircleSharpIonIcon",
    "ScanCircleIonIcon",
    "ScanOutlineIonIcon",
    "ScanSharpIonIcon",
    "ScanIonIcon",
    "SchoolOutlineIonIcon",
    "SchoolSharpIonIcon",
    "SchoolIonIcon",
    "SearchCircleOutlineIonIcon",
    "SearchCircleSharpIonIcon",
    "SearchCircleIonIcon",
    "SearchOutlineIonIcon",
    "SearchSharpIonIcon",
    "SearchIonIcon",
    "SendOutlineIonIcon",
    "SendSharpIonIcon",
    "SendIonIcon",
    "ServerOutlineIonIcon",
    "ServerSharpIonIcon",
    "ServerIonIcon",
    "SettingsOutlineIonIcon",
    "SettingsSharpIonIcon",
    "SettingsIonIcon",
    "ShapesOutlineIonIcon",
    "ShapesSharpIonIcon",
    "ShapesIonIcon",
    "ShareOutlineIonIcon",
    "ShareSharpIonIcon",
    "ShareSocialOutlineIonIcon",
    "ShareSocialSharpIonIcon",
    "ShareSocialIonIcon",
    "ShareIonIcon",
    "ShieldCheckmarkOutlineIonIcon",
    "ShieldCheckmarkSharpIonIcon",
    "ShieldCheckmarkIonIcon",
    "ShieldHalfOutlineIonIcon",
    "ShieldHalfSharpIonIcon",
    "ShieldHalfIonIcon",
    "ShieldOutlineIonIcon",
    "ShieldSharpIonIcon",
    "ShieldIonIcon",
    "ShirtOutlineIonIcon",
    "ShirtSharpIonIcon",
    "ShirtIonIcon",
    "ShuffleOutlineIonIcon",
    "ShuffleSharpIonIcon",
    "ShuffleIonIcon",
    "SkullOutlineIonIcon",
    "SkullSharpIonIcon",
    "SkullIonIcon",
    "SnowOutlineIonIcon",
    "SnowSharpIonIcon",
    "SnowIonIcon",
    "SparklesOutlineIonIcon",
    "SparklesSharpIonIcon",
    "SparklesIonIcon",
    "SpeedometerOutlineIonIcon",
    "SpeedometerSharpIonIcon",
    "SpeedometerIonIcon",
    "SquareOutlineIonIcon",
    "SquareSharpIonIcon",
    "SquareIonIcon",
    "StarHalfOutlineIonIcon",
    "StarHalfSharpIonIcon",
    "StarHalfIonIcon",
    "StarOutlineIonIcon",
    "StarSharpIonIcon",
    "StarIonIcon",
    "StatsChartOutlineIonIcon",
    "StatsChartSharpIonIcon",
    "StatsChartIonIcon",
    "StopCircleOutlineIonIcon",
    "StopCircleSharpIonIcon",
    "StopCircleIonIcon",
    "StopOutlineIonIcon",
    "StopSharpIonIcon",
    "StopIonIcon",
    "StopwatchOutlineIonIcon",
    "StopwatchSharpIonIcon",
    "StopwatchIonIcon",
    "StorefrontOutlineIonIcon",
    "StorefrontSharpIonIcon",
    "StorefrontIonIcon",
    "SubwayOutlineIonIcon",
    "SubwaySharpIonIcon",
    "SubwayIonIcon",
    "SunnyOutlineIonIcon",
    "SunnySharpIonIcon",
    "SunnyIonIcon",
    "SwapHorizontalOutlineIonIcon",
    "SwapHorizontalSharpIonIcon",
    "SwapHorizontalIonIcon",
    "SwapVerticalOutlineIonIcon",
    "SwapVerticalSharpIonIcon",
    "SwapVerticalIonIcon",
    "SyncCircleOutlineIonIcon",
    "SyncCircleSharpIonIcon",
    "SyncCircleIonIcon",
    "SyncOutlineIonIcon",
    "SyncSharpIonIcon",
    "SyncIonIcon",
    "TabletLandscapeOutlineIonIcon",
    "TabletLandscapeSharpIonIcon",
    "TabletLandscapeIonIcon",
    "TabletPortraitOutlineIonIcon",
    "TabletPortraitSharpIonIcon",
    "TabletPortraitIonIcon",
    "TelescopeOutlineIonIcon",
    "TelescopeSharpIonIcon",
    "TelescopeIonIcon",
    "TennisballOutlineIonIcon",
    "TennisballSharpIonIcon",
    "TennisballIonIcon",
    "TerminalOutlineIonIcon",
    "TerminalSharpIonIcon",
    "TerminalIonIcon",
    "TextOutlineIonIcon",
    "TextSharpIonIcon",
    "TextIonIcon",
    "ThermometerOutlineIonIcon",
    "ThermometerSharpIonIcon",
    "ThermometerIonIcon",
    "ThumbsDownOutlineIonIcon",
    "ThumbsDownSharpIonIcon",
    "ThumbsDownIonIcon",
    "ThumbsUpOutlineIonIcon",
    "ThumbsUpSharpIonIcon",
    "ThumbsUpIonIcon",
    "ThunderstormOutlineIonIcon",
    "ThunderstormSharpIonIcon",
    "ThunderstormIonIcon",
    "TicketOutlineIonIcon",
    "TicketSharpIonIcon",
    "TicketIonIcon",
    "TimeOutlineIonIcon",
    "TimeSharpIonIcon",
    "TimeIonIcon",
    "TimerOutlineIonIcon",
    "TimerSharpIonIcon",
    "TimerIonIcon",
    "TodayOutlineIonIcon",
    "TodaySharpIonIcon",
    "TodayIonIcon",
    "ToggleOutlineIonIcon",
    "ToggleSharpIonIcon",
    "ToggleIonIcon",
    "TrailSignOutlineIonIcon",
    "TrailSignSharpIonIcon",
    "TrailSignIonIcon",
    "TrainOutlineIonIcon",
    "TrainSharpIonIcon",
    "TrainIonIcon",
    "TransgenderOutlineIonIcon",
    "TransgenderSharpIonIcon",
    "TransgenderIonIcon",
    "TrashBinOutlineIonIcon",
    "TrashBinSharpIonIcon",
    "TrashBinIonIcon",
    "TrashOutlineIonIcon",
    "TrashSharpIonIcon",
    "TrashIonIcon",
    "TrendingDownOutlineIonIcon",
    "TrendingDownSharpIonIcon",
    "TrendingDownIonIcon",
    "TrendingUpOutlineIonIcon",
    "TrendingUpSharpIonIcon",
    "TrendingUpIonIcon",
    "TriangleOutlineIonIcon",
    "TriangleSharpIonIcon",
    "TriangleIonIcon",
    "TrophyOutlineIonIcon",
    "TrophySharpIonIcon",
    "TrophyIonIcon",
    "TvOutlineIonIcon",
    "TvSharpIonIcon",
    "TvIonIcon",
    "UmbrellaOutlineIonIcon",
    "UmbrellaSharpIonIcon",
    "UmbrellaIonIcon",
    "UnlinkOutlineIonIcon",
    "UnlinkSharpIonIcon",
    "UnlinkIonIcon",
    "VideocamOffOutlineIonIcon",
    "VideocamOffSharpIonIcon",
    "VideocamOffIonIcon",
    "VideocamOutlineIonIcon",
    "VideocamSharpIonIcon",
    "VideocamIonIcon",
    "VolumeHighOutlineIonIcon",
    "VolumeHighSharpIonIcon",
    "VolumeHighIonIcon",
    "VolumeLowOutlineIonIcon",
    "VolumeLowSharpIonIcon",
    "VolumeLowIonIcon",
    "VolumeMediumOutlineIonIcon",
    "VolumeMediumSharpIonIcon",
    "VolumeMediumIonIcon",
    "VolumeMuteOutlineIonIcon",
    "VolumeMuteSharpIonIcon",
    "VolumeMuteIonIcon",
    "VolumeOffOutlineIonIcon",
    "VolumeOffSharpIonIcon",
    "VolumeOffIonIcon",
    "WalkOutlineIonIcon",
    "WalkSharpIonIcon",
    "WalkIonIcon",
    "WalletOutlineIonIcon",
    "WalletSharpIonIcon",
    "WalletIonIcon",
    "WarningOutlineIonIcon",
    "WarningSharpIonIcon",
    "WarningIonIcon",
    "WatchOutlineIonIcon",
    "WatchSharpIonIcon",
    "WatchIonIcon",
    "WaterOutlineIonIcon",
    "WaterSharpIonIcon",
    "WaterIonIcon",
    "WifiOutlineIonIcon",
    "WifiSharpIonIcon",
    "WifiIonIcon",
    "WineOutlineIonIcon",
    "WineSharpIonIcon",
    "WineIonIcon",
    "WomanOutlineIonIcon",
    "WomanSharpIonIcon",
    "WomanIonIcon"
  )
}

allIcons <- function(){
  c(chakraIcons(), superTinyIcons(), ionIcons())
}
