#' runAppx
#'
#' Runs an example Shiny app via [shiny::runExample()].
#'
#' @details Note that for running a Shiny app more libraries might be necessary.
#'
#' @param example character: name of the example to run, or NA to list the available examples
#' @param x data frame: data to pass to the app
#' @param ... further parameter given to [shiny::runExample()]
#'
#' @return invisibly the (modified) data set `x`
#' @importFrom shiny runExample
#' @export
#'
#' @examples
#' # Example requires the use of a `shiny` app (See Vignette)
#' # List all available examples
#' runAppx(NA)
#'
#' \dontrun{
#' # Run the "mini" example app
#' runAppx("mini")
#'
#' # Run with a dataset passed to the app
#' check <- data.frame(a = 1:9)
#' runAppx("mini", x = check)
#'
#' # Can also pass arguments to shiny::runExample
#' runAppx("mini", display.mode = "showcase")
#' }
runAppx <- function(example = "mini", x = NULL, ...) {
  tmpfile <- tempfile(pattern = "dtc", fileext = ".rds")
  saveRDS(x, tmpfile, version = 2)
  options(shinyDTC.data = tmpfile)
  args <- list(...)
  args$example <- example
  args$package <- "shinyDTC"
  do.call(runExample, args)
  x <- readRDS(tmpfile)
  invisible(x)
}
