% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_shiny.R
\name{run_shiny}
\alias{run_shiny}
\title{Solve equations}
\usage{
run_shiny(model = "SIR", neweqns = NULL, ics = NULL, tstart = 0,
  timestep = 1, tmax = 365, parm0 = NULL, parm_names = NULL,
  parm_min = NULL, parm_max = NULL, sigfigs = 4, showtable = TRUE,
  linesize = 1.2, textsize = 14, xlabel = "Time",
  ylabel = "Number of individuals", legend_title = "Compartment",
  slider_steps = NULL, values = NULL, ...)
}
\arguments{
\item{model}{name of the model to be solved. Examples of built-in models are: "SIR", "SIR vaccination". Default is "SIR".}

\item{neweqns}{function specifying the equations of the user-defined model. Only to be used if a model is required that is not built-in. Default is NULL.}

\item{ics}{named numeric vector specifying the initial conditions i.e. the initial values of all model variables. Default is c(S = 9999, I = 1, R = 0) for the SIR model.}

\item{tstart}{numerical value of form c(tmin, tmax) indicating the time to start simulations. Default value is 0.}

\item{timestep}{numerical value indicating time step be used when solving equations. Default value is 1/365.}

\item{tmax}{numerical value indicating maximum time point to be considered.}

\item{parm0}{named numeric vector of starting parameter values. Names must correspond to those used in the model equations.}

\item{parm_names}{character vector of parameter names to be displayed in shiny menu. Must be in the same order as 'parm0'.}

\item{parm_min}{named numeric vector of minimum parameter values.}

\item{parm_max}{named numeric vector of maximum parameter values.}

\item{sigfigs}{number of significant figures to round parameter input vectors. Default is 4.}

\item{showtable}{logical TRUE/FALSE. Should the table of transformed parameters be shown? Only applies to built-in models. Default is TRUE.}

\item{linesize}{numeric value for line width in ggplot output. Default is 1.2.}

\item{textsize}{numeric value for textsize in ggplot output. Default is 14.}

\item{xlabel}{character string for x axis plotting label. Default is "Time".}

\item{ylabel}{character string for y axis plotting label. Default is "Number of individuals".}

\item{legend_title}{character string for legend title. Default is "Compartment".}

\item{slider_steps}{numeric vector of step size to include between slider input values. Should be NULL or a vector with an entry for each parameter input. Default is NULL.}

\item{values}{vector specifying manual color scale (if desired). Length must equal the number of model variables.}

\item{...}{extra argument to be passed through to ggplot scale_colour_manual: use 'labels' to change the legend names.}
}
\value{
data frame of model solutions in long format.
}
\description{
This function solves an ODE model using 'deSolve' and returns the output as a data frame.
}
\examples{
\donttest{
run_shiny(model = "SIR")
}

}
