% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tree_traversal.R
\name{set_node_attrs}
\alias{set_node_attrs}
\title{Tree traversal}
\usage{
set_node_attrs(tree, attr_name, inner_val, leaf_val)
}
\arguments{
\item{tree}{named nested list}

\item{attr_name}{name of attribute to set}

\item{inner_val}{value of attribute for inner tree nodes}

\item{leaf_val}{value of attribute for outer tree nodes}
}
\value{
named nested list
}
\description{
Traverse through tree/list to set node attributes, e.g. change icons.
Useful for directory structure icons where inner nodes are directories, leafs are files.
}
\examples{
tree <- dfToTree(data.frame(Titanic),  c("Sex", "Survived"))
str(set_node_attrs(tree, attr_name = "sttype", inner_val = "directory", leaf_val = "file"))

}
