% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/croneditor.R
\name{cron}
\alias{cron}
\title{Cron editor, creates a 'htmlwidgets' object, for use in a 'shiny' dashboard}
\usage{
cron(schedule, width = NULL, height = NULL, elementId = NULL)
}
\arguments{
\item{schedule}{Any valid cron schedule, for example "0 6 * * *"}

\item{width}{How wide should the editor be? Defaults to NULL, meaning 100\%}

\item{height}{How high should the editor be? Defaults to NULL, meaning 32px}

\item{elementId}{Optionally specifiy the ID of the element}
}
\value{
Returns a 'htmlwidgets' object that can be used in a 'shiny' app
}
\description{
Cron editor, creates a 'htmlwidgets' object, for use in a 'shiny' dashboard
}
\examples{
# A simple cron editor in a Shiny app
if (interactive()) {
library(shiny)
library(shinycroneditor)

ui <- fluidPage(
titlePanel("Cron Expression Input Widget"),
mainPanel(
  shinycroneditor::cronOutput("cronschedule1", 
                              label = "Choose your first schedule", 
                              language = "en-US"),
   
   shiny::div(
     "Your first chosen schedule is: ",
     verbatimTextOutput("cronExpression1")
   ),
   
   shinycroneditor::cronOutput("cronschedule2", 
                               label = "Choose your second schedule", 
                               language = "en-US"),
   
   shiny::div(
     "Your chosen second schedule is: ",
     verbatimTextOutput("cronExpression2")
   )
 )
)

server <- function(input, output, session) {
 
 output$cronschedule1 <- shinycroneditor::renderCron({
   shinycroneditor::cron("0 6 * * *")
 })
 
 output$cronExpression1 <- renderPrint({
   input$cronschedule1
 })
 
 output$cronschedule2 <- shinycroneditor::renderCron({
   shinycroneditor::cron("30 1,3,7 * * *")
 })
 
 output$cronExpression2 <- renderPrint({
   input$cronschedule2
 })
 
}

shinyApp(ui, server)
}

}
