% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/croneditor.R
\name{croneditor-shiny}
\alias{croneditor-shiny}
\alias{cronOutput}
\alias{renderCron}
\title{Shiny bindings for cron editor}
\usage{
cronOutput(
  outputId,
  label = NULL,
  language = "en-US",
  width = "100\%",
  height = NULL
)

renderCron(expr, env = parent.frame(), quoted = FALSE)
}
\arguments{
\item{outputId}{output variable to read from}

\item{label}{The label to show, just like in a regular Shiny input element.
Set to NULL if you don't want a label.}

\item{language}{The language the cron editor's UI will be in. Choose one of
en-US, nl-NL, es-ES, zh-CN. Note that if you have multiple cron editors
on one page, the last editor's language will be the one for all editors.}

\item{width, height}{Must be a valid CSS unit (like \code{'100\%'},
\code{'400px'}, \code{'auto'}) or a number, which will be coerced to a
string and have \code{'px'} appended.}

\item{expr}{An expression that generates a test}

\item{env}{The environment in which to evaluate \code{expr}.}

\item{quoted}{Is \code{expr} a quoted expression (with \code{quote()})? This
is useful if you want to save an expression in a variable.}
}
\value{
An 'htmlwidgets' object for use in a shiny app, containing a
placeholder for where the cron input element is rendered.

A 'htmlwidgets' object for use in a 'shiny' app as an input element
}
\description{
Output and render functions for using cron editor within 'shiny'
applications and interactive 'rmarkdown' documents.
}
