% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_functions.R
\name{plot.shrinkTVPVAR_fit}
\alias{plot.shrinkTVPVAR_fit}
\title{Graphical summary of posterior distribution of fitted values for TVP-VAR model}
\usage{
\method{plot}{shrinkTVPVAR_fit}(x, nplot = 3, h_borders = c(0.05, 0.05), w_borders = c(0.02, 0.02), ...)
}
\arguments{
\item{x}{a \code{shrinkTVPVAR_fit} object.}

\item{nplot}{single integer value, determining the number of plots (i.e. number of equations to visualize at once) to be generated.
The default value is 3.}

\item{h_borders}{numeric vector of length 2, determining the horizontal borders of the plot.
The first value is the space between the plot and the left border,
the second value is the space between the plot and the right border.
Both are fractions of the total width of the plot. The default value is \code{c(0.05, 0.05)}.}

\item{w_borders}{numeric vector of length 2, determining the vertical borders of the plot.
The first value is the space between the plot and the top border,
the second value is the space between the plot and the bottom border.
Both are fractions of the total height of the plot. The default value is \code{c(0.02, 0.02)}.}

\item{...}{further arguments to be passed to \code{\link[graphics]{plot}}.}
}
\value{
Called for its side effects and returns invisibly.
}
\description{
\code{plot.shrinkTVPVAR_fit} generates plots visualizing the posterior distribution of fitted values
of a model generated by a call to \code{shrinkTVPVAR}.
}
\examples{
\donttest{
set.seed(123)
sim <- simTVPVAR(p = 2)
data <- sim$data

res <- shrinkTVPVAR(data, p = 2)
fit <- fitted(res)
plot(fit)
}

}
\seealso{
Other plotting functions: 
\code{\link{TV_heatmap}()},
\code{\link{density_plotter}()},
\code{\link{plot.mcmc.tvp.var}()},
\code{\link{plot.mcmc.var}()},
\code{\link{plot.shrinkTVPVAR}()},
\code{\link{plot.shrinkTVPVAR_forc}()},
\code{\link{state_plotter}()}
}
\author{
Peter Knaus \email{peter.knaus@wu.ac.at}
}
\concept{plotting functions}
