% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graph_proxies.R
\name{read-batch}
\alias{read-batch}
\alias{sg_read_delay_nodes_p}
\alias{sg_read_delay_edges_p}
\alias{sg_read_delay_exec_p}
\title{Batch read}
\usage{
sg_read_delay_nodes_p(proxy, data, ..., delay)

sg_read_delay_edges_p(proxy, data, ..., delay)

sg_read_delay_exec_p(proxy, refresh = TRUE)
}
\arguments{
\item{proxy}{An object of class \code{sigmajsProxy} as returned by \code{\link{sigmajsProxy}}.}

\item{data}{A \code{data.frame} of nodes or edges to add to the graph.}

\item{...}{any column.}

\item{delay}{Column name of containing batch identifier.}

\item{refresh}{Whether to refresh the graph after each batch (\code{delay}) has been added to the graph.
Note that this will also automatically restart any running force layout.}
}
\value{
The \code{proxy} object.
}
\description{
Read nodes and edges by batch with a delay.
}
\details{
Add nodes and edges with \code{sg_read_delay_nodes_p} and \code{sg_read_delay_edges_p} then execute (send to JavaScript end) with \code{sg_read_delay_exec_p}.
}
\examples{
library(shiny)

ui <- fluidPage(
	actionButton("add", "add nodes & edges"),
	sigmajsOutput("sg")
)

server <- function(input, output, session){

	output$sg <- renderSigmajs({
		sigmajs()
	})

	observeEvent(input$add, {
		nodes <- sg_make_nodes(50)
		nodes$batch <- c(
			rep(1000, 25),
			rep(3000, 25)
		)

		edges <- data.frame(
			id = 1:80,
			source = c(
				sample(1:25, 40, replace = TRUE),
				sample(1:50, 40, replace = TRUE)
			),
			target = c(
				sample(1:25, 40, replace = TRUE),
				sample(1:50, 40, replace = TRUE)
			),
			batch = c(
				rep(1000, 40),
				rep(3000, 40)
			)
		) \%>\% 
		dplyr::mutate_all(as.character)

		sigmajsProxy("sg") \%>\% 
     sg_force_start_p() \%>\% 
			sg_read_delay_nodes_p(nodes, id, color, label, size, delay = batch) \%>\% 
			sg_read_delay_edges_p(edges, id, source, target, delay = batch) \%>\% 
			sg_read_delay_exec_p()  \%>\% 
			sg_force_stop_p()
	})

}

if(interactive()) shinyApp(ui, server)

}
