% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/store_raster.R
\name{store_raster}
\alias{store_raster}
\title{Store Raster to PostGIS}
\usage{
store_raster(raster, conn, schema = "public", table_name = NULL)
}
\arguments{
\item{raster}{A character string specifying the file path to the GeoTIFF raster file
to be stored.}

\item{conn}{A database connection object to a PostGIS database (e.g., from `RPostgres::dbConnect`).}

\item{schema}{A string specifying the schema in the PostGIS database where
the raster layers will be stored. Default is `"public"`.}

\item{table_name}{A string, table name. If it is `NULL`, which is the default value,
the layer name is derived from the filename.}
}
\value{
Invisibly returns a character vector of the names of the tables written to PostGIS.
}
\description{
Stores all bands of a raster to a specified schema in a PostGIS database.
All bands are written in the same table in the database.
}
\details{
Transforms the table name according to the Snake Case convention.
}
\examples{
\dontrun{
source_tif <- system.file("extdata", "mdt.tif", package = "clc")

conn <- DBI::dbConnect(
  RPostgres::Postgres(),
  dbname = "mydb",
  host = "localhost",
  user = "user",
  password = "password"
)

tables <- store_raster(source_tif, conn, table_name = "mdt")

DBI::dbDisconnect(conn)
}

}
\seealso{
Other write to PostGIS: 
\code{\link{store_bands}()},
\code{\link{store_layers}()}
}
\concept{write to PostGIS}
