% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.simBA.R
\name{plot.simBA}
\alias{plot.simBA}
\title{Plot the results of a simulation}
\usage{
\method{plot}{simBA}(x, type = "balance", ...)
}
\arguments{
\item{x}{a \code{simBA} object; the output of a call to \code{\link[=simBA]{simBA()}}.}

\item{type}{the type of plot to produce; allowable options include \code{"balance"} (default), \code{"hr"}, and \code{"bias"}. Abbreviations allowed. See Details.}

\item{...}{further arguments passed to \code{\link[ggplot2:geom_boxplot]{ggplot2::geom_boxplot()}}.}
}
\value{
A \code{ggplot} object, which can be modified using \code{ggplot2} syntax.
}
\description{
\code{plot()} plots the output of a call to \code{simBA()}. The plot can contain either the estimated hazard ratios or standardized mean differences across simulations, each in a set of box plots.
}
\details{
The balance plot plots absolute standardized mean differences. Vertical lines are placed at 0 (solid) and .1 (dashed). The hazard ratio (HR) plot plots hazard ratios on a log scale for the x-axis. Vertical lines are placed at 1 (solid) and the true marginal HR (dashed). The bias plot plots the relative error in the HR with a vertical line at 0\% (indicating no error).
}
\examples{
# See help("simBA") for examples.

}
\seealso{
\code{\link[=simBA]{simBA()}} for performing the simulation.
}
