% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_stutter_regression.R
\name{read_stutter_regression}
\alias{read_stutter_regression}
\title{Reads a stutter regression file}
\usage{
read_stutter_regression(filename, min_stutter_ratio = 0.001)
}
\arguments{
\item{filename}{Character. Path to file.}

\item{min_stutter_ratio}{Numeric.}
}
\value{
A function that takes a locus name and allele as arguments and returns the expected stutter ratio.
}
\description{
Reads a stutter regression file
}
\details{
Reads the file from disk and returns a function that provides the expected stutter ratio for a given locus and allele.
}
\examples{
filename <- system.file("extdata","GlobalFiler_Stutter_3500.txt",
                        package = "simDNAmixtures")
regression <- read_stutter_regression(filename)

# obtain the expected stutter ratio for a 12 parent allele at the vWA locus
regression("vWA", 12)
}
