% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/survivalFunctions.R
\name{WeibSurvOS}
\alias{WeibSurvOS}
\title{OS Survival Function from Weibull Transition Hazards}
\usage{
WeibSurvOS(t, h01, h02, h12, p01, p02, p12)
}
\arguments{
\item{t}{(\code{numeric})\cr  study time-points.}

\item{h01}{(positive \code{number})\cr transition hazard for 0 to 1 transition.}

\item{h02}{(positive \code{number})\cr transition hazard for 0 to 2 transition.}

\item{h12}{(positive \code{number})\cr transition hazard for 1 to 2 transition.}

\item{p01}{(positive \code{number})\cr rate parameter of Weibull distribution for \code{h01}.}

\item{p02}{(positive \code{number})\cr rate parameter of Weibull distribution for \code{h02}.}

\item{p12}{(positive \code{number})\cr rate parameter of Weibull distribution for \code{h12}.}
}
\value{
This returns the value of OS survival function at time t.
}
\description{
OS Survival Function from Weibull Transition Hazards
}
\examples{
WeibSurvOS(c(1:5), 0.2, 0.5, 2.1, 1.2, 0.9, 1)
}
