% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getClinicalTrials.R
\name{getClinicalTrials}
\alias{getClinicalTrials}
\title{Simulation of a Large Number of Oncology Clinical Trials}
\usage{
getClinicalTrials(nRep, ..., seed = 1234, datType = "1rowTransition")
}
\arguments{
\item{nRep}{(\code{int})\cr number of simulated trials.}

\item{...}{parameters transferred to \code{\link[=getOneClinicalTrial]{getOneClinicalTrial()}}, see \code{\link[=getOneClinicalTrial]{getOneClinicalTrial()}} for details.}

\item{seed}{(\code{int})\cr random seed used for this simulation.}

\item{datType}{(\code{string})\cr possible values are \verb{1rowTransition} and \verb{1rowPatient}.}
}
\value{
This function returns a list with \code{nRep} simulated data sets in the format specified by \code{datType}.
See \code{\link[=getDatasetWideFormat]{getDatasetWideFormat()}} \code{\link[=getOneClinicalTrial]{getOneClinicalTrial()}} for details.
}
\description{
Simulation of a Large Number of Oncology Clinical Trials
}
\examples{
transition1 <- exponential_transition(h01 = 1.2, h02 = 1.5, h12 = 1.6)
transition2 <- exponential_transition(h01 = 1, h02 = 1.3, h12 = 1.7)
getClinicalTrials(
  nRep = 10, nPat = c(20, 20), seed = 1234, datType = "1rowTransition",
  transitionByArm = list(transition1, transition2), dropout = list(rate = 0.5, time = 12),
  accrual = list(param = "intensity", value = 7)
)
}
