% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bias.R
\name{bias}
\alias{bias}
\title{Calculate the bias}
\usage{
bias(true_value, estimates, get = c("bias", "bias_mcse"), na.rm = FALSE, ...)
}
\arguments{
\item{true_value}{The true value which is being estimated.}

\item{estimates}{A numeric vector containing the estimates from the model(s).}

\item{get}{A character vector containing the values returned by the function.}

\item{na.rm}{A logical value indicating whether NA values for \code{estimates} should be removed before bias calculation.}

\item{...}{Additional arguments to be ignored.}
}
\value{
A named vector containing the estimate and the Monte Carlo standard error for the bias.
}
\description{
Calculates the bias of the model estimates from the true value and the Monte Carlo standard error for this estimate.
}
\examples{
bias(true_value=0, estimates=rnorm(100))
}
