% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/relativePrecision.R
\name{relativePrecision}
\alias{relativePrecision}
\title{Calculates the relative (\%) increase in precision between two methods}
\usage{
relativePrecision(
  estimates_A,
  estimates_B,
  get = c("relativePrecision", "relativePrecision_mcse"),
  na.rm = FALSE
)
}
\arguments{
\item{estimates_A}{A numeric vector containing the estimates from model A.}

\item{estimates_B}{A numeric vector containing the estimates from model B.}

\item{get}{A character vector containing the values returned by the function.}

\item{na.rm}{A logical value indicating whether NA values for \code{estimates} should be removed before empSE calculation.}
}
\value{
A named vector containing the estimate and the Monte Carlo standard error for the relative (\%) increase in precision of method B versus method A.
}
\description{
Calculates the relative (\%) increase in precision between two competing methods (B vs A). As this metric compares two methods directly, it cannot be used in \code{join_metrics()}.
}
\examples{
relativePrecision(estimates_A=rnorm(n=1000), estimates_B=rnorm(n=1000))
}
