% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simaerep_plot.R
\name{plot_dots}
\alias{plot_dots}
\title{Plots AE per site as dots.}
\usage{
plot_dots(
  df,
  nrow = 10,
  ncols = 10,
  col_group = "site",
  thresh = NULL,
  color_site_a = "#BDBDBD",
  color_site_b = "#757575",
  color_site_c = "gold3",
  color_high = "#00695C",
  color_low = "#25A69A",
  size_dots = 10
)
}
\arguments{
\item{df}{dataframe, cols = c('site', 'patients', 'n_ae')}

\item{nrow}{integer, number of rows, Default: 10}

\item{ncols}{integer, number of columns, Default: 10}

\item{col_group}{character, grouping column, Default: 'site'}

\item{thresh}{numeric, threshold to determine color of mean_ae annotation, Default: NULL}

\item{color_site_a}{character, hex color value, Default: '#BDBDBD'}

\item{color_site_b}{character, hex color value, Default: '#757575'}

\item{color_site_c}{character, hex color value, Default: 'gold3'}

\item{color_high}{character, hex color value, Default: '#00695C'}

\item{color_low}{character, hex color value, Default: '#25A69A'}

\item{size_dots}{integer, Default: 10}
}
\value{
ggplot object
}
\description{
This plot is meant to supplement the package documentation.
}
\examples{
study <- tibble::tibble(
  site = LETTERS[1:3],
  patients = c(list(seq(1, 50, 1)), list(seq(1, 40, 1)), list(seq(1, 10, 1)))
) \%>\%
  tidyr::unnest(patients) \%>\%
  dplyr::mutate(n_ae = as.integer(runif(min = 0, max = 10, n = nrow(.))))

plot_dots(study)
}
