% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simer.Data.R
\name{simer.Data.MVP2Bfile}
\alias{simer.Data.MVP2Bfile}
\title{simer.Data.MVP2Bfile: To transform MVP data to binary format}
\usage{
simer.Data.MVP2Bfile(
  bigmat,
  map,
  pheno = NULL,
  out = "simer",
  threads = 1,
  verbose = TRUE
)
}
\arguments{
\item{bigmat}{Genotype in bigmatrix format (0,1,2).}

\item{map}{the map file.}

\item{pheno}{the phenotype file.}

\item{out}{the name of output file.}

\item{threads}{the number of threads used, if NULL, (logical core number - 1) is automatically used.}

\item{verbose}{whether to print the reminder.}
}
\value{
NULL
Output files:
.bed, .bim, .fam
}
\description{
transforming MVP data to binary format.
}
\details{
Build date: Sep 12, 2018
Last update: Jan 29, 2025
}
\examples{
\donttest{
library(bigmemory)

# Generate bigmat and map
bigmat <- as.big.matrix(matrix(1:6, 3, 2))
map <- generate.map(pop.marker = 3)

# Data converting
simer.Data.MVP2Bfile(bigmat, map, out=tempfile("outfile"))
}
}
\author{
Haohao Zhang and Dong Yin
}
