% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/batch_simulation.R
\name{arg_set-class}
\alias{arg_set-class}
\alias{new_arg_set}
\alias{add_arg_ele}
\alias{nele}
\alias{narg}
\alias{print.arg_set}
\alias{make_arg_grid}
\alias{print.arg_grid}
\title{Create and modify argument sets, then make an argument grid
for batch simulation}
\usage{
new_arg_set()

add_arg_ele(arg_set, arg_name, ele_name, start, end, by)

nele(arg_set)

narg(arg_set)

\method{print}{arg_set}(x, detail = FALSE, ...)

make_arg_grid(arg_set)

\method{print}{arg_grid}(x, detail = FALSE, ...)
}
\arguments{
\item{arg_set}{An \code{arg_set} object.}

\item{arg_name, ele_name}{The name of the argument and its element
in the simulation function}

\item{start, end, by}{The data points where you want to test the variables.
Passed to \code{seq}.}

\item{x}{An \code{arg_set} object}

\item{detail}{Do you want to print the object details as a full list?}

\item{...}{Not in use.}
}
\value{
\code{new_arg_set()} returns an \code{arg_set} object.

\code{add_arg_ele()} returns an \code{arg_set} object.

\code{nele()} returns an integer.

\code{narg()} returns an integer.

\code{make_arg_gird()} returns an \code{arg_grid} object.
}
\description{
An argument set contains the descriptions of the relevant variables in a
batch simulation. Use \code{new_arg_set()} to create an \code{arg_set}
object, and use \code{add_arg_ele()} to add an element to the \code{arg_set}. After
adding all elements in the argument set, use \code{make_arg_grid()} to make an
argument grid that can be used directly for running batch simulation.
}
\section{Functions}{
\itemize{
\item \code{new_arg_set()}: Create an \code{arg_set}.

\item \code{add_arg_ele()}: Add an element to an \code{arg_set}.

\item \code{nele()}: The number of elements in an \code{arg_set}.

\item \code{narg()}: The number of arguments in an \code{arg_set}.

\item \code{print(arg_set)}: Print an \code{arg_set} object.

\item \code{make_arg_grid()}: Make an argument grid from an argument set.

\item \code{print(arg_grid)}: Print an \code{arg_grid} object

}}
\seealso{
\code{\link[=batch_simulation]{batch_simulation()}} for running batch simulation and a
concrete example.
}
