% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simrec_plot.R
\name{simrecPlot}
\alias{simrecPlot}
\title{simrecPlot}
\usage{
simrecPlot(data, id = "id", start = "start", stop = "stop", status = "status")
}
\arguments{
\item{data}{A data set of recurrent event data to be plotted.
The input-data must include columns corresponding to:
\code{id} (patient-ID), \code{start} (= beginning of an interval where the patient is at risk for an event),
\code{stop} (= end of the interval due to an event or censoring),
\code{status} (= an indicator of the patient status at \code{stop} with = 0 censoring, 1 = event)}

\item{id}{the name of the \code{id} column, default is \code{"id"}}

\item{start}{the name of the \code{start} column, default is \code{"start"}}

\item{stop}{the name of the \code{stop} column, default is \code{"stop"}}

\item{status}{the name of the \code{status} column, default is \code{"status"}}
}
\value{
The output  is a plot of the data with a bullet indicating a recurrent event and a circle indicating censoring.
}
\description{
This function allows plotting of recurrent event data.
}
\examples{
### Example:
### First simulate a sample of 10 individuals (for more details see the help of \code{simrec})
N <- 10
dist.x <- c("binomial", "normal")
par.x <- list(0.5, c(0, 1))
beta.x <- c(0.3, 0.2)
dist.z <- "gamma"
par.z <- 0.25
dist.rec <- "weibull"
par.rec <- c(1, 2)
fu.min <- 2
fu.max <- 2
cens.prob <- 0.2
dfree <- 30 / 365
pfree <- 0.5
simdata <- simrec(
  N, fu.min, fu.max, cens.prob, dist.x, par.x, beta.x,
  dist.z, par.z, dist.rec, par.rec, pfree, dfree
)
simrecPlot(simdata)
}
\seealso{
simrec, simreccomp, simreccompPlot
}
\author{
Katharina Ingel, Stella Preussler, Antje Jahn-Eimermacher.
Institute of Medical Biostatistics, Epidemiology and Informatics (IMBEI),
University Medical Center of the Johannes Gutenberg-University Mainz, Germany
}
