% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evaluate.R
\name{evaluate}
\alias{evaluate}
\title{Evaluate outputs of methods according to provided metrics.}
\usage{
evaluate(object, metrics)
}
\arguments{
\item{object}{object of class \code{\linkS4class{OutputRef}} as produced by
\code{\link{run_method}} (or list of such objects). If
\code{object} is a \code{\linkS4class{Simulation}}, then function is applied
 to the referenced outputs in that simulation and returns the same
\code{Simulation} object but with references added to the new evals
created.}

\item{metrics}{a list of \code{\linkS4class{Metric}} objects or a single
\code{\linkS4class{Metric}} object.}
}
\description{
Given a \code{\linkS4class{Metric}} object or list of \code{\linkS4class{Metric}} objects,
this function evaluates an \code{\linkS4class{Output}} object according to these
metrics.  The computed values of the metrics are saved to file.  The "user"
time to run the method (as measured by \code{\link{system.time}}) is added
to \code{metrics} by default unless one of the passed metrics has name
"time".
}
\details{
This function creates objects of class \code{\linkS4class{Evals}} and saves each to
file (at dir/model_name/<out_loc>/r<index>_<method_name>_evals.Rdata. Since
evaluating metrics is usually (in statistical methodological papers) fast,
parallel functionality has not been developed for the evaluation component.
}
\examples{
\dontrun{
 # suppose previously we had run the following:
 sim <- new_simulation(name = "normal-example",
                       label = "Normal Mean Estimation",
                       dir = tempdir()) \%>\%
   generate_model(make_my_example_model, n = 20) \%>\%
   simulate_from_model(nsim = 50, index = 1:3) \%>\%
   run_method(my_example_method)
 # then we could add
 sim <- evaluate(sim, my_example_loss)
 }
}
\seealso{
\code{\link{generate_model}} \code{\link{simulate_from_model}}
\code{\link{run_method}}
}
