% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/draws.R
\name{load_draws}
\alias{load_draws}
\title{Load one or more draws objects from file.}
\usage{
load_draws(dir, model_name, index, more_info = FALSE, simulator.files = NULL)
}
\arguments{
\item{dir}{the directory passed to \code{\link{generate_model}})}

\item{model_name}{the Model object's \code{name} attribute}

\item{index}{a vector of positive integers.}

\item{more_info}{if TRUE, then returns additional information such as
state of RNG after calling \code{\link{generate_model}}}

\item{simulator.files}{if NULL, then \code{getOption("simulator.files")}
will be used.}
}
\description{
After \code{\link{simulate_from_model}} has been called, this function can
be used to load one or more of the saved \code{\linkS4class{Draws}} object(s)
(along with RNG information).  If multiple indices are provided, these will
be combined into a new single \code{\linkS4class{Draws}} object.
If simulation object is available, it is easier to use the function
\code{\link{draws}} to load it.
}
\seealso{
\code{\link{simulate_from_model}} \code{\link{draws}}
}
