% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/database-redshift.R
\name{aws_db_redshift_create}
\alias{aws_db_redshift_create}
\title{Create a Redshift cluster}
\usage{
aws_db_redshift_create(
  id,
  user,
  pwd,
  dbname = "dev",
  cluster_type = "multi-node",
  node_type = "dc2.large",
  number_nodes = 2,
  security_group_ids = NULL,
  wait = TRUE,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{id}{(character) Cluster identifier. Use this identifier to refer to
the cluster for any subsequent cluster operations such as deleting or
modifying. The identifier also appears in the Amazon Redshift console.
Must be unique for all clusters within a Amazon Web Services account.}

\item{user}{(character) User name associated with the admin user account for
the cluster that is being created. This is the username for your IAM account}

\item{pwd}{(character) Password associated with the admin user account for
the cluster that is being created. This is the password for your IAM account}

\item{dbname}{(character) The name of the first database to be created when
the cluster is created. default: "dev". additional databases can be created
within the cluster}

\item{cluster_type}{(character) The type of the cluster: "single-node" or
"multi-node" (default).}

\item{node_type}{(character) The node type to be provisioned for the cluster.
defaul: "dc2.large"}

\item{number_nodes}{(integer/numeric) number of nodes; for multi-node
cluster type, this must be 2 or greater. default: 2}

\item{security_group_ids}{(character) VPC security group identifiers; one
or more. If none are supplied, you should go into your AWS Redshift
dashboard and add the appropriate VPC security group.}

\item{wait}{(logical) wait for cluster to initialize? default: \code{TRUE}. If
you don't wait (\code{FALSE}) then there's many operations you can not do
until the cluster is available. If \code{wait=FALSE} use
\code{aws_db_cluster_status()} to check on the cluster status.}

\item{verbose}{(logical) verbose informational output? default: \code{TRUE}}

\item{...}{named parameters passed on to
\href{https://www.paws-r-sdk.com/docs/redshift_create_cluster/}{create_cluster}}
}
\value{
returns \code{NULL}, this function called for the side effect of
creating an Redshift instance
}
\description{
Create a Redshift cluster
}
\note{
See above link to \code{create_cluster} docs for details on requirements
for each parameter
}
\section{Waiting}{

Note that with \code{wait = TRUE} this function waits for the instance to be
available for returning. That wait can be around 5 - 7 minutes. You can
instead set \code{wait = FALSE} and then check on the status of the instance
yourself in the AWS dashboard.
}

\seealso{
Other database: 
\code{\link{aws_db_cluster_status}()},
\code{\link{aws_db_instance_status}()},
\code{\link{aws_db_rds_con}()},
\code{\link{aws_db_rds_create}()},
\code{\link{aws_db_rds_list}()},
\code{\link{aws_db_redshift_con}()}
}
\concept{database}
