% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/files.R
\name{aws_file_exists}
\alias{aws_file_exists}
\title{Check if a file exists}
\usage{
aws_file_exists(remote_path)
}
\arguments{
\item{remote_path}{(character) one or more remote S3 paths. required}
}
\value{
vector of booleans (\code{TRUE} or \code{FALSE}), length matches
\code{length(remote_path)}
}
\description{
Check if a file exists
}
\examples{
\dontshow{if (aws_has_creds()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
library(glue)
bucket <- random_bucket()
aws_bucket_create(bucket)

# upload some files
tfiles <- replicate(n = 3, tempfile())
paths <- s3_path(bucket, glue("{basename(tfiles)}.txt"))
for (file in tfiles) cat("Hello saturn!!!!!!\n", file = file)
for (file in tfiles) print(readLines(file))
aws_file_upload(path = tfiles, remote_path = paths)

# check that files exist
aws_file_exists(paths[1])
aws_file_exists(paths[2])
aws_file_exists(s3_path(bucket, "doesnotexist.txt"))

# Cleanup
six_bucket_delete(bucket, force = TRUE)
\dontshow{\}) # examplesIf}
}
\seealso{
Other files: 
\code{\link{aws_file_attr}()},
\code{\link{aws_file_copy}()},
\code{\link{aws_file_delete}()},
\code{\link{aws_file_download}()},
\code{\link{aws_file_rename}()},
\code{\link{aws_file_upload}()},
\code{\link{six_file_upload}()}
}
\concept{files}
