% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/users.R
\name{aws_user_add_to_group}
\alias{aws_user_add_to_group}
\alias{aws_user_remove_from_group}
\title{Add or remove a user to/from a group}
\usage{
aws_user_add_to_group(username, groupname)

aws_user_remove_from_group(username, groupname)
}
\arguments{
\item{username}{(character) A user name. required}

\item{groupname}{(character) a group name. required}
}
\value{
a named list with slots for:
\itemize{
\item user (tibble)
\item policies (list)
\item attached_policies (list)
\item groups (list)
}
}
\description{
Add or remove a user to/from a group
}
\details{
See \url{https://www.paws-r-sdk.com/docs/iam_add_user_to_group/}
\url{https://www.paws-r-sdk.com/docs/iam_remove_user_from_group/}
docs for more details
}
\examples{
\dontshow{if (interactive() && aws_has_creds()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
group1 <- random_string("group")
if (!aws_group_exists(group1)) {
  aws_group_create(group1)
}
name1 <- random_user()
if (!aws_user_exists(name1)) {
  aws_user_create(name1)
}
aws_user_add_to_group(name1, group1)
aws_group(group1) # has user name1
aws_user_remove_from_group(name1, group1)
aws_group(group1) # does not have user name1
\dontshow{\}) # examplesIf}
}
\seealso{
Other users: 
\code{\link{aws_user}()},
\code{\link{aws_user_access_key}()},
\code{\link{aws_user_access_key_delete}()},
\code{\link{aws_user_create}()},
\code{\link{aws_user_current}()},
\code{\link{aws_user_delete}()},
\code{\link{aws_user_exists}()},
\code{\link{aws_users}()},
\code{\link{six_user_create}()},
\code{\link{six_user_delete}()}
}
\concept{users}
