% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stk_calibrate.R
\name{stk_calibrate}
\alias{stk_calibrate}
\title{Estimate scale the scale range}
\usage{
stk_calibrate(
  df,
  percentile = 100,
  floor = 1.5,
  distribution = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{df}{a skytrackr dataframe}

\item{percentile}{percentile of the diurnal data (abvoe the floor value)
used in calculating daily statistics (default = 100)}

\item{floor}{threshold to remove low (nighttime) values}

\item{distribution}{provide the full distribution across the track of scale
factors (default = FALSE, providing only a range as a global constraint)}

\item{verbose}{Give detailed feedback (TRUE or FALSE, default = TRUE)}
}
\value{
An estimated range of scale values to be used in optimization.
 Values are not log transformed.
}
\description{
Provides a rough estimate on the light loss and corresponding
range of scale values to consider during optimization.
A percentile parameter can be provided to remove outliers. It is
recommended to first use `st_screen_twl()` to remove poor quality days.
}
\examples{

# Estimate the upper scale value for fitting routine
upper_scale_value <- cc876 |> stk_calibrate()
}
