% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/curate-dead-animals.R
\name{curate_dead_animals}
\alias{curate_dead_animals}
\title{Remove -- irrelevant -- data after individual have died}
\usage{
curate_dead_animals(
  data,
  moving_var = moving,
  time_window = hours(24),
  prop_immobile = 0.01,
  resolution = 24
)
}
\arguments{
\item{data}{\link[data.table:data.table]{data.table::data.table} containing behavioural variable from or one multiple animals.
When it has a key, unique values, are assumed to represent unique individuals (e.g. in a \link[behavr:behavr]{behavr::behavr} table).
Otherwise, it analysis the data as coming from a single animal. \code{data} must have a column \code{t} representing time.}

\item{moving_var}{logical variable in \code{data} used to define the moving (alive) state (default is \code{moving})}

\item{time_window}{window during which to define death (default is one day)}

\item{prop_immobile}{proportion of immobility that counts as "dead" during time_window (see details)}

\item{resolution}{how much scanning windows overlap. Expressed as a factor (see details).}
}
\value{
an object of the same type as \code{data} (i.e. \link[data.table:data.table]{data.table::data.table} or \link[behavr:behavr]{behavr::behavr}).
}
\description{
This function detects when individuals have died based on their first (very) long bout of immobility.
Following data (which may include spurious artefact of movement) are removed.
}
\details{
This function scans the time series looking for "death" in the right (future) data, within \code{time_window}.
Death is defined as \code{mean(moving_var) < prop_immobile} within a time window.
Moving window start every \code{time_window/resolution}. \code{resolution = 1} is fast but means no overlap.
The default would score an animal as dead it does not move more than \emph{one percent of the time} for at least \emph{one day}.
All data following a "death" event are removed.
}
\examples{
dt1 <- toy_activity_data()
#all movement after day 3 is set at 0
dt1[t > days(3), moving := FALSE]
# one artefact of movement is detected at day 3.5
dt1[t == days(3.5), moving := TRUE]

dt2 <- curate_dead_animals(dt1)
dt3 <- curate_dead_animals(dt1,prop_immobile = 0)
\dontrun{
library(ggplot2)
ggplot(data=dt1[,test:=1],aes(t, as.numeric(moving))) +
  geom_line(data=dt1[,test:=1]) +
  geom_line(data=dt2[, test:=2])+
  geom_line(data=dt3[, test:=3])+
  facet_grid(test ~ .)+
  scale_x_time()
}
}
\seealso{
\itemize{
\item \link{sleep_annotation} -- to score movement and sleep
}
}
