% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_infectiousness_density.R
\name{get_infectiousness_density}
\alias{get_infectiousness_density}
\title{Dataframe with dates and infectiousness probability}
\usage{
get_infectiousness_density(
  symptom_begin_date,
  infectiousness_shift = 12.272481,
  max_infectious_days = 24,
  shape_infectiousness_gamma = 20.516508,
  rate_infectiousness_gamma = 1.592124
)
}
\arguments{
\item{symptom_begin_date}{Date, when the person gets symptoms.}

\item{infectiousness_shift}{Number of days with the largest contagions before the first symptoms.}

\item{max_infectious_days}{Number of the infectious days.}

\item{shape_infectiousness_gamma}{Number, the shape parameter for the gamma distribution.}

\item{rate_infectiousness_gamma}{Number, the rate parameter for the gamma distribution.}
}
\value{
Dataframe with dates and infectiousness probability.
}
\description{
Creates a dataframe containing infectiousness at a particular date/time,
given the symptom_begin_date.
}
\details{
infectiousness_shift, shape_infectiousness_gamma and rate_infectiousness_gamma
are the distribution parameters for the infectious period from He et al. (2020).
}
\examples{
get_infectiousness_density(as.Date("2022-03-22"))
get_infectiousness_density(as.Date("2022-03-22"), infectiousness_shift = 12.272481,
                           max_infectious_days = 24, shape_infectiousness_gamma = 20.516508,
                           rate_infectiousness_gamma = 1.592124)

}
\references{
He, X et al. (2020) "Temporal dynamics in viral shedding and
transmissibility of COVID-19". \emph{Nature Medicine}, 26: 672–675.
}
