% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/db_index.R
\name{db_index}
\alias{db_index}
\alias{db_index_create}
\alias{db_index_delete}
\title{Create and get database indexes}
\usage{
db_index(cushion, dbname, as = "list", ...)

db_index_create(cushion, dbname, body, as = "list", ...)

db_index_delete(cushion, dbname, design, index_name, as = "list", ...)
}
\arguments{
\item{cushion}{A \code{\link{Cushion}} object. Required.}

\item{dbname}{(character) Database name, required}

\item{as}{(character) One of list (default) or json}

\item{...}{Curl args passed on to \code{\link[crul]{HttpClient}}}

\item{body}{(named list) index fields, required}

\item{design}{(character) Design document name}

\item{index_name}{(character) index name}
}
\value{
JSON as a character string or a list (determined by the
\code{as} parameter)
}
\description{
Create and get database indexes
}
\section{Body parameters}{

\itemize{
\item index (json) - JSON object describing the index to create.
\item ddoc (string) - Name of the design document in which the index will be
created. By default, each index will be created in its own design
document. Indexes can be grouped into design documents for efficiency.
However, a change to one index in a design document will invalidate all
other indexes in the same document (similar to views). Optional
\item name (string) - Name of the index. If no name is provided, a name will
be generated automatically. Optional
\item type (string) - Can be "json" or "text". Defaults to json. Geospatial
indexes will be supported in the future. Optional Text indexes are
supported via a third party library Optional
\item partial_filter_selector (json) - A selector to apply to documents at
indexing time, creating a partial index. Optional
}
}

\examples{
\dontrun{
user <- Sys.getenv("COUCHDB_TEST_USER")
pwd <- Sys.getenv("COUCHDB_TEST_PWD")
(x <- Cushion$new(user=user, pwd=pwd))

# create a database first
if ("testing" \%in\% db_list(x)) {
  invisible(db_delete(x, dbname="testing"))
}
db_create(x, "testing")

# get indexes
db_index(x, "testing")

# create indexes
body <- list(index = list(fields = I("foo")), name = "foo-index", type = "json")
db_index_create(x, "testing", body = body)

# get indexes, after creating another index
db_index(x, "testing")

# delete an index
res <- db_index(x, "testing")
db_index_delete(x, "testing", res$indexes[[2]]$ddoc, res$indexes[[2]]$name)
## and it's gone
db_index(x, "testing")
}
}
