% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/thinning_til_n.R
\name{thinning_til_n}
\alias{thinning_til_n}
\title{Applies thinning to pairs of coordinates until reaching a given n}
\usage{
thinning_til_n(
  xy,
  n = 30,
  distance.step = NULL
)
}
\arguments{
\item{xy}{A data frame with columns named "x" and "y" representing geographic coordinates. Default: \code{NULL}}

\item{n}{Integer, number of samples to obtain. Must be lower than \code{nrow(xy)}. Default: \code{30}}

\item{distance.step}{Numeric, distance step used during the thinning iterations. If \code{NULL}, the one percent of the maximum distance among points in \code{xy} is used. Default: \code{NULL}}
}
\value{
A data frame with the same columns as xy with a row number close to n.
}
\description{
Resamples a set of points with x and y coordinates by increasing the distance step by step until a given sample size is obtained.
}
\examples{
if(interactive()){

 #loading example data
 data(plant_richness_df)

 #thinning to ~20 records
 plant_richness.thin <- thinning_til_n(
   x = plant_richness_df,
   n = 20
   )

 plant_richness.thin

}
}
\seealso{
\code{\link[=thinning]{thinning()}}
}
