% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_importance.R
\name{get_importance}
\alias{get_importance}
\title{Extract variable importance from model}
\usage{
get_importance(model)
}
\arguments{
\item{model}{Model object from \code{\link[=rf]{rf()}}, \code{\link[=rf_repeat]{rf_repeat()}}, or \code{\link[=rf_spatial]{rf_spatial()}}.}
}
\value{
Data frame with columns \code{variable} (character) and \code{importance} (numeric), sorted by decreasing importance.
}
\description{
Extracts variable importance scores from models fitted with \code{\link[=rf]{rf()}}, \code{\link[=rf_repeat]{rf_repeat()}}, or \code{\link[=rf_spatial]{rf_spatial()}}.
}
\details{
For spatial models (\code{\link[=rf_spatial]{rf_spatial()}}) with many spatial predictors, this function returns aggregated importance statistics for spatial predictors to improve readability. Non-spatial models return per-variable importance scores directly.
}
\examples{
data(plants_rf)

# Extract variable importance
importance <- get_importance(plants_rf)
head(importance)

# View top 5 most important variables
importance[1:5, ]

}
\seealso{
\code{\link[=rf]{rf()}}, \code{\link[=rf_repeat]{rf_repeat()}}, \code{\link[=rf_spatial]{rf_spatial()}}, \code{\link[=plot_importance]{plot_importance()}}, \code{\link[=print_importance]{print_importance()}}

Other model_info: 
\code{\link{get_evaluation}()},
\code{\link{get_importance_local}()},
\code{\link{get_moran}()},
\code{\link{get_performance}()},
\code{\link{get_predictions}()},
\code{\link{get_residuals}()},
\code{\link{get_response_curves}()},
\code{\link{get_spatial_predictors}()},
\code{\link{print.rf}()},
\code{\link{print_evaluation}()},
\code{\link{print_importance}()},
\code{\link{print_moran}()},
\code{\link{print_performance}()}
}
\concept{model_info}
