% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/moran_multithreshold.R
\name{moran_multithreshold}
\alias{moran_multithreshold}
\title{Moran's I test across multiple distance thresholds}
\usage{
moran_multithreshold(
  x = NULL,
  distance.matrix = NULL,
  distance.thresholds = NULL,
  verbose = TRUE
)
}
\arguments{
\item{x}{Numeric vector to test for spatial autocorrelation. Typically model residuals or a response variable.}

\item{distance.matrix}{Numeric distance matrix between observations. Must have the same number of rows as the length of \code{x}.}

\item{distance.thresholds}{Numeric vector of distance thresholds defining different neighborhood scales. Each threshold specifies the maximum distance for spatial neighbors at that scale. Default: \code{NULL} (automatically computed with \code{\link[=default_distance_thresholds]{default_distance_thresholds()}}).}

\item{verbose}{Logical. If \code{TRUE}, displays a plot of Moran's I values across distance thresholds. Default: \code{TRUE}.}
}
\value{
List with four elements:
\itemize{
\item \code{per.distance}: Data frame with one row per distance threshold, containing columns:
\itemize{
\item \code{distance.threshold}: Distance threshold used
\item \code{moran.i}: Observed Moran's I statistic
\item \code{moran.i.null}: Expected Moran's I under null hypothesis
\item \code{p.value}: Two-tailed p-value
\item \code{interpretation}: Text interpretation of the result
}
\item \code{plot}: ggplot object showing how Moran's I varies across distance thresholds, highlighting significant results.
\item \code{max.moran}: Numeric value of the maximum Moran's I observed across all thresholds.
\item \code{max.moran.distance.threshold}: Distance threshold (in distance matrix units) where Moran's I is maximized.
}
}
\description{
Computes Moran's I at multiple distance thresholds to assess spatial autocorrelation across different neighborhood scales. Identifies the distance threshold with the strongest spatial autocorrelation.
}
\details{
This function applies \code{\link[=moran]{moran()}} at multiple distance thresholds to explore spatial autocorrelation at different spatial scales. This multi-scale approach is valuable for several reasons:
\itemize{
\item \strong{Scale exploration}: Different processes may operate at different spatial scales. Testing multiple thresholds reveals the scale(s) at which spatial autocorrelation is strongest.
\item \strong{Optimal neighborhood definition}: Identifies the distance threshold that best captures the spatial structure in the data.
\item \strong{Uncertainty assessment}: Spatial neighborhoods are often uncertain in ecological and spatial data. Testing multiple thresholds accounts for this uncertainty.
}

\strong{Interpreting results:}

The plot shows Moran's I values across distance thresholds. Peaks in Moran's I indicate spatial scales where autocorrelation is strongest. The \code{max.moran} and \code{max.moran.distance.threshold} values identify the optimal scale. Significant results (p equal or lower than 0.05) indicate spatial autocorrelation at that particular scale.

This function is commonly used to:
\enumerate{
\item Detect spatial autocorrelation in model residuals at multiple scales
\item Determine appropriate distance thresholds for generating spatial predictors with \code{\link[=mem_multithreshold]{mem_multithreshold()}}
\item Assess whether spatial patterns vary across scales
}
}
\examples{
data(plants_df, plants_distance, plants_response)

# Test spatial autocorrelation at multiple distance thresholds
moran_multi <- moran_multithreshold(
  x = plants_df[[plants_response]],
  distance.matrix = plants_distance,
  distance.thresholds = c(0, 1000, 5000)
)

# View results for all thresholds
moran_multi$per.distance

# Find optimal distance threshold
moran_multi$max.moran.distance.threshold
moran_multi$max.moran

# Plot shows spatial autocorrelation across scales
moran_multi$plot

}
\seealso{
\code{\link[=moran]{moran()}}, \code{\link[=mem_multithreshold]{mem_multithreshold()}}, \code{\link[=default_distance_thresholds]{default_distance_thresholds()}}, \code{\link[=get_moran]{get_moran()}}

Other spatial_analysis: 
\code{\link{filter_spatial_predictors}()},
\code{\link{mem}()},
\code{\link{mem_multithreshold}()},
\code{\link{moran}()},
\code{\link{pca}()},
\code{\link{pca_multithreshold}()},
\code{\link{rank_spatial_predictors}()},
\code{\link{residuals_diagnostics}()},
\code{\link{residuals_test}()},
\code{\link{select_spatial_predictors_recursive}()},
\code{\link{select_spatial_predictors_sequential}()}
}
\concept{spatial_analysis}
