% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print_moran.R
\name{print_moran}
\alias{print_moran}
\title{Prints results of a Moran's I test}
\usage{
print_moran(
  model,
  caption = NULL,
  verbose = TRUE
)
}
\arguments{
\item{model}{A model fitted with \code{\link[=rf]{rf()}}, \code{\link[=rf_repeat]{rf_repeat()}}, or \code{\link[=rf_spatial]{rf_spatial()}}.}

\item{caption}{Character, caption of the output table, Default: \code{NULL}}

\item{verbose}{Logical, if \code{TRUE}, the resulting table is printed into the console, Default: \code{TRUE}}
}
\value{
Prints a table in the console using the \link[huxtable]{huxtable} package.
}
\description{
Prints the results of a Moran's I test on the residuals of a model.
}
\examples{

data(plants_rf)

print_moran(plants_rf)

}
\seealso{
\code{\link[=moran]{moran()}}, \code{\link[=moran_multithreshold]{moran_multithreshold()}}, \code{\link[=get_moran]{get_moran()}}, \code{\link[=plot_moran]{plot_moran()}}

Other model_info: 
\code{\link{get_evaluation}()},
\code{\link{get_importance}()},
\code{\link{get_importance_local}()},
\code{\link{get_moran}()},
\code{\link{get_performance}()},
\code{\link{get_predictions}()},
\code{\link{get_residuals}()},
\code{\link{get_response_curves}()},
\code{\link{get_spatial_predictors}()},
\code{\link{print.rf}()},
\code{\link{print_evaluation}()},
\code{\link{print_importance}()},
\code{\link{print_performance}()}
}
\concept{model_info}
