% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linear-spherical-spline.R
\name{spherical_to_cartesian}
\alias{spherical_to_cartesian}
\title{Convert spherical coordinates to Cartesian coordinates}
\usage{
spherical_to_cartesian(theta_phi, byrow = TRUE)
}
\arguments{
\item{theta_phi}{A matrix where each row contains the spherical coordinates (theta, phi) of a point.}

\item{byrow}{logical. If TRUE (the default) the matrix is filled by rows, otherwise the matrix is filled by columns.}
}
\value{
A matrix where each row contains the Cartesian coordinates (x, y, z) of a point.
}
\description{
This function converts spherical coordinates (theta, phi) to Cartesian coordinates.
}
\examples{
theta_phi <- matrix(c(pi/4, pi/3, pi/6, pi/4), ncol = 2, byrow = TRUE)
spherical_to_cartesian(theta_phi)
}
