#' Convert a timestamp to a SQUID
#'
#' Convert a timestamp (the number of seconds that passed since the first of January, 1970)
#' to a SQUID.
#'
#' @param x The timestamp (or a vector of timestamps)
#'
#' @returns The SQUID(s)
#' @export
#'
#' @examples timestamp <-
#'   as.numeric(Sys.time());
#'
#' squids::timestamp_to_squids(
#'   timestamp
#' );
timestamp_to_squids <- function(x) {

  if (is.null(x) || all(is.na(x))) {
    return(x);
  }

  if (!is.numeric(x)) {
    stop("As `x`, you have to pass a numeric vector. You passed a vector of ",
         "class ", vecTxt(class(x)), ".");
  }

  timeNrString <- round(as.numeric(x) * 100, 0);

  res <-
    unlist(lapply(timeNrString,
                  numericToBase30));

  class(res) <- c("squids", class(res));

  return(res);

}
