% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opts.R
\docType{data}
\name{opts}
\alias{opts}
\alias{set}
\alias{get}
\alias{reset}
\title{Options for the squids package}
\format{
An object of class \code{list} of length 4.
}
\usage{
opts
}
\description{
The \code{squids::opts} object contains three functions to set, get, and reset
options used by the zirconia package. Use \code{squids::opts$set} to set options,
\code{squids::opts$get} to get options, or \code{squids::opts$reset} to reset specific or
all options to their default values.
}
\details{
It is normally not necessary to get or set \code{squids} options.

The following arguments can be passed:

\describe{
\item{...}{For \code{squids::opts$set}, the dots can be used to specify the options
to set, in the format \code{option = value}, for example, \code{utteranceMarker = "\\n"}. For
\code{squids::opts$reset}, a list of options to be reset can be passed.}
\item{option}{For \code{squids::opts$set}, the name of the option to set.}
\item{default}{For \code{squids::opts$get}, the default value to return if the
option has not been manually specified.}
}

The following options can be set:

\describe{

\item{silent}{Whether to be silent or chatty.}
\item{encoding}{The default encoding when reading or writing files.}
\item{preventOverwriting}{Whether to be prevent overwriting of existing files.}
\item{debug}{Sometimes used to display debugging information.}

}
}
\examples{
### Get the default 'silent' setting
squids::opts$get(silent);

### Set it to FALSE (to be chatty)
squids::opts$set(silent = FALSE);

### Check that it worked
squids::opts$get(silent);

### Reset this option to its default value
squids::opts$reset(silent);

### Check that the reset worked, too
squids::opts$get(silent);

}
\keyword{datasets}
