% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ss_best_normal.R
\name{power_best_normal}
\alias{power_best_normal}
\title{Power calculation for the Indifferent-zone approach for normal outcomes}
\usage{
power_best_normal(dif, sd, ngroups, npergroup, seed = NULL)
}
\arguments{
\item{dif}{Numeric. Indifferent-zone. Minimum difference that is considered meaningful.}

\item{sd}{Numeric. Common standard deviation of the response variable.}

\item{ngroups}{Integer. Number of groups (treatments) being compared.}

\item{npergroup}{Integer. Number in each group.}

\item{seed}{Optional. Integer seed to use in the internal call to \code{multp()}.}
}
\value{
Integer. Sample size required per group to achieve the specified power.
}
\description{
Estimate the probability of correctly select the best group among
\code{ngroups} groups  if the difference between the best group and the next best
is at least \code{dif}(the Indifferent-Zone), and the standard deviation is \code{sd}
}
\note{
The function uses the quantile function \code{multp()}, which computes critical values
for the selection procedure. This implementation assumes equal variances and independent samples.
}
\examples{
power_best_normal(dif = 0.5, sd = 1, ngroups = 3, npergroup = 11)

}
