% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stagedtrees.R
\docType{package}
\name{stagedtrees}
\alias{stagedtrees-package}
\alias{stagedtrees}
\title{Staged event trees.}
\description{
Algorithms to create, learn, fit and explore staged event tree models.
Functions to compute probabilities, make predictions from the fitted
models and to plot, analyze and manipulate staged event trees.
}
\details{
A staged event tree is a representation of a particular
factorization of a joint probability over a product space.
In particular, given a vector of categorical random variables
\eqn{X1, X2, \ldots}, a staged event tree represents the factorization
\eqn{P(X1, X2, X3, \ldots) = P(X1)P(X2 | X1) P(X3 | X1, X2) \ldots }.
Additionally, the stages structure indicates which conditional probabilities
are equal.

Model selection algorithms:
\itemize{
\item full model \code{\link{full}}
\item independence model \code{\link{indep}}
\item Hill-Climbing \code{\link{stages_hc}}
\item Backward Hill-Climbing \code{\link{stages_bhc}}
\item Fast Backward Hill-Climbing \code{\link{stages_fbhc}}
\item Backward Hill-Climbing Random \code{\link{stages_bhcr}}
\item Backward joining \code{\link{stages_bj}}
\item Simple Backward Hill-Climbing \code{\link{stages_simplebhc}}
\item Hierarchical Clustering \code{\link{stages_hclust}}
\item K-Means Clustering \code{\link{stages_kmeans}}
\item Optimal order search \code{\link{search_best}}
\item Greedy order search \code{\link{search_greedy}}
}

Probabilities, log-likelihood and predictions:
\itemize{
\item Marginal/Conditional probabilities \code{\link{prob}}
\item Log-Likelihood \code{\link{logLik.sevt}}
\item Predict method \code{\link{predict.sevt}}
\item Confidence intervals \code{\link{confint.sevt}}
}

Plot, explore and compare:
\itemize{
\item Plot \code{\link{plot.sevt}}
\item Compare \code{\link{compare_stages}}
\item Stages inclusion \code{\link{inclusions_stages}}
\item Stages info \code{\link{summary.sevt}}
\item List of parents \code{\link{as_parentslist}}
\item Barplot construction \code{\link{barplot.sevt}}
\item Likelihood-ratio test \code{\link{lr_test}}
\item Context-specific interventional distance \code{\link{cid}}
}

Modify models:
\itemize{
\item Join and isolate unobserved situations \code{\link{join_unobserved}}
\item Join two stages \code{\link{join_stages}}
\item Join two positions \code{\link{join_positions}}
\item Rename a stage \code{\link{rename_stage}}
}
}
\examples{
data("PhDArticles")
mf <- full(PhDArticles, join_unobserved = TRUE)
mod <- stages_fbhc(mf)
plot(mod)
}
\references{
Collazo R. A., Görgen C. and Smith J. Q.
Chain event graphs. CRC Press, 2018.

Görgen C., Bigatti A., Riccomagno E. and Smith J. Q.
Discovery of statistical equivalence classes using computer algebra.
\emph{International Journal of Approximate Reasoning}, vol. 95, pp. 167-184, 2018.

Barclay L. M., Hutton J. L. and Smith J. Q.
Refining a Bayesian network using a chain event graph.
\emph{International Journal of Approximate Reasoning}, vol. 54, pp. 1300-1309, 2013.

Smith J. Q. and Anderson P. E.
Conditional independence and chain event graphs.
\emph{Artificial Intelligence}, vol. 172, pp. 42-68, 2008.

Thwaites P. A., Smith, J. Q.
A new method for tackling asymmetric decision problems.
\emph{International Journal of Approximate Reasoning}, vol. 88, pp. 624–639, 2017.
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/stagedtrees/stagedtrees}
  \item Report bugs at \url{https://github.com/stagedtrees/stagedtrees/issues}
}

}
\author{
\strong{Maintainer}: Gherardo Varando \email{gherardo.varando@gmail.com} (\href{https://orcid.org/0000-0002-6708-1103}{ORCID})

Authors:
\itemize{
  \item Federico Carli
  \item Manuele Leonelli (\href{https://orcid.org/0000-0002-2562-5192}{ORCID})
  \item Eva Riccomagno
}

}
