% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weighted_ordinal_pattern_distribution.R
\name{weighted_ordinal_pattern_distribution}
\alias{weighted_ordinal_pattern_distribution}
\title{A function to compute weighted ordinal pattern statistics}
\usage{
weighted_ordinal_pattern_distribution(x, ndemb)
}
\arguments{
\item{x}{A numeric vector (e.g. a time series), from which the weighted ordinal pattern distribution is to be calculated}

\item{ndemb}{Embedding dimension of the ordinal patterns (i.e. sliding window size). Should be chosen such as length(x) >> ndemb}
}
\value{
A character vector of length factorial(ndemb) is returned.
}
\description{
Computation of weighted ordinal patterns of a time series. Weights can be generated by a user-specified function (e.g. variance-weighted, see Fadlallah et al 2013).
}
\details{
This function returns the distribution of weighted ordinal patterns using the Keller coding scheme, detailed in Physica A 356 (2005) 114-120. NA values are allowed.
The function uses old and slow R routines and is only maintained for comparability. 
For faster routines, see \link{weighted_ordinal_pattern_distribution}.
}
\examples{
x = arima.sim(model=list(ar = 0.3), n = 10^4)
weighted_ordinal_pattern_distribution(x = x, ndemb = 6)
}
\references{
Fadlallah, B., Chen, B., Keil, A. and Principe, J., 2013. Weighted-permutation entropy: A complexity measure for time series incorporating amplitude information. Physical Review E, 87(2), p.022911.
}
\seealso{
\code{\link{weighted_ordinal_pattern_distribution}}
}
\author{
Sebastian Sippel
}
