% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readPlink.R
\name{readPLINK}
\alias{readPLINK}
\title{Read PLINK binary data}
\usage{
readPLINK(bed, bim, fam, ...)
}
\arguments{
\item{bed}{The name of the file containing the packed binary SNP genotype
data. It should have the extension .bed; If it doesn't, then this extension
will be appended.}

\item{bim}{The file containing the SNP descriptions. If not specified
\code{bed} is used with its file extension replaced by bim.}

\item{fam}{The file containing subject (and, possibly, family) identifiers.
This is basically a tab-delimited "pedfile". If not specified
\code{bed} is used with its file extension replaced by fam.}

\item{...}{Further arguments passed to \link[snpStats:read.plink]{snpStats::read.plink}.}
}
\value{
An object of class \code{gData}.
}
\description{
Read PLINK binary data and save in gData format. This is a wrapper around
\link[snpStats:read.plink]{snpStats::read.plink} in the Bioconductor package
\code{snpStats}. This package needs to be installed for the function to
work.
}
