% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print_stdmod.R
\name{print.std_selected}
\alias{print.std_selected}
\title{Print Basic Information of a 'std_selected' Class Object}
\usage{
\method{print}{std_selected}(x, ...)
}
\arguments{
\item{x}{The output of \code{\link[=std_selected]{std_selected()}} or \code{\link[=std_selected_boot]{std_selected_boot()}}.}

\item{...}{Arguments to be passed to \code{\link[=print]{print()}} method of \code{\link[=lm]{lm()}}.}
}
\value{
\code{x} is returned invisibly.
}
\description{
Provide information of centering and scaling, along with
basic model information printed by the \code{\link[=print]{print()}} method of \code{\link[=lm]{lm()}}.
}
\examples{

# Load a sample data set

dat <- test_x_1_w_1_v_1_cat1_n_500

# Do a moderated regression by lm
lm_raw <- lm(dv ~ iv*mod + v1 + cat1, dat)
summary(lm_raw)

# Standardize all variables except for categorical variables.
# Interaction terms are formed after standardization.
lm_std <- std_selected(lm_raw, to_scale = ~ .,
                               to_center = ~ .)
lm_std

# With bootstrapping
# nboot = 100 just for illustration. nboot >= 2000 should be used in read
# research.
lm_std_boot <- std_selected_boot(lm_raw, to_scale = ~ .,
                                         to_center = ~ .,
                                         nboot = 100)
lm_std_boot

}
\author{
Shu Fai Cheung \url{https://orcid.org/0000-0002-9871-9448}
}
