% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GroupFuncs.R
\name{GroupAssignment}
\alias{GroupAssignment}
\alias{print.GroupAssignment}
\alias{summary.GroupAssignment}
\title{Assign to groups based on GroupConditions}
\usage{
GroupAssignment(
  data,
  conditions,
  id,
  force_disjoint,
  force_exhaustive,
  skip_faulty = FALSE,
  .all = FALSE,
  ...
)

\method{print}{GroupAssignment}(x, ...)

\method{summary}{GroupAssignment}(object, ...)
}
\arguments{
\item{data}{data.frame containing observations}

\item{conditions}{\emph{GroupConditions} object}

\item{id}{\emph{character} name of the column containing unique \strong{ID} of the
observations to assign to each group. If not provided, indices
will be used instead.}

\item{force_disjoint}{\emph{boolean} indicating if groups disjointedness should be
forced in case when one observation would pass conditions for more than one
group. If \code{TRUE}, the first condition which will be met will indicate
the group the observation will be assigned to. If not provided, the default
from \code{conditions} will be used}

\item{force_exhaustive}{\emph{boolean} indicating if groups exhausiveness should
be forced in case when there are observations that don't pass any of the provided
conditions. If \code{TRUE}, then they will be assigned to \code{.NA} group. If not provided, the default
from \code{conditions} will be used}

\item{skip_faulty}{\emph{boolean} should the faulty \code{condition} be skipped?
If \code{FALSE} as in default, error will be produced. Faultiness of seemingly correct
condition may be caused by variable names to not be present in the \code{data}.}

\item{.all}{\emph{boolean}. If \code{TRUE}, then additional group named \code{.all}
will be created, which will contain all observations. Useful when object will be
used for creation of \code{\link[=GroupedFrequencyTable]{GroupedFrequencyTable()}}}

\item{...}{additional arguments to be passed to or from method}

\item{x}{object}

\item{object}{\code{GroupAssignment} object}
}
\value{
\emph{GroupAssignment} object

list of summaries, invisibly
}
\description{
Using \emph{GroupConditions} object, assign observations to one
of the groups. It can export either indices of the observations, or their
unique \strong{ID}: if column name is provided in \code{id} argument. Mostly used internally
by more complex functions and \verb{R6 classes}, but could also be useful
on its own.
}
\examples{
age_grouping <- GroupConditions(
  conditions_category = "Age",
  "to 20" ~ age < 20,
  "20 to 40" ~ age >= 20 & age <= 40,
  "40 to 60" ~ age >= 40 & age < 60
)

# on basis of GroupConditions create GroupAssignment

age_assignment <- GroupAssignment(
  data = HEXACO_60,
  age_grouping)

print(age_assignment)

# overwrite the default settings imposed by `GroupConditions`

age_assignment_forced <- GroupAssignment(
  data = HEXACO_60,
  age_grouping,
  force_exhaustive = TRUE)

summary(age_assignment_forced)

# you can also use other unique identifier from your data

age_assignment_forced_w_id <- GroupAssignment(
  data = HEXACO_60,
  age_grouping,
  id = "user_id",
  force_exhaustive = TRUE)

summary(age_assignment_forced_w_id)
}
\seealso{
Other observation grouping functions: 
\code{\link{extract_observations}()},
\code{\link{intersect_GroupAssignment}()}
}
\concept{observation grouping functions}
