% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GroupFuncs.R
\name{GroupConditions}
\alias{GroupConditions}
\alias{print.GroupConditions}
\alias{as.data.frame.GroupConditions}
\title{Conditions for observation grouping}
\usage{
GroupConditions(
  conditions_category,
  ...,
  force_disjoint = TRUE,
  force_exhaustive = FALSE,
  .dots = list()
)

\method{print}{GroupConditions}(x, ...)

\method{as.data.frame}{GroupConditions}(x, ...)
}
\arguments{
\item{conditions_category}{\emph{chracter} value describing character of the group
conditions. Mainly informative.}

\item{...}{additional arguments to be passed to or from methods.}

\item{force_disjoint}{\emph{boolean} indicating if the condition formulas by default
should be handled with \code{force_disjoint} strategy. By default \code{TRUE}.
If \code{TRUE}, the first condition which will be met will indicate
the group the observation will be assigned to.}

\item{force_exhaustive}{\emph{boolean} indicating if groups exhaustiveness should
be forced in case when there are observations that don't pass any of the provided
conditions. If \code{TRUE}, then they will be assigned to \code{.NA} group. Defaults
to \code{FALSE}}

\item{.dots}{\emph{formulas} in form of a \emph{list}}

\item{x}{\code{GroupConditions} object}
}
\value{
\emph{GroupConditions} object
}
\description{
With help of this function you can create GroupingConditions
object, holding the basis of observation grouping. Objects of this class
can be provided to complex functions to automatically group observations
accordingly.
}
\examples{
# create GroupConditions with formula-style conditions per each group

sex_grouping <- GroupConditions(
  conditions_category = "Sex",
  "M" ~ sex == "M",
  "F" ~ sex == "F",
  "O" ~ !sex \%in\% c("M", "F")
)
print(sex_grouping)

# GroupConditions can also mark if the groups should be handled by default
# with forced disjoint (default `TRUE`) and exhaustiveness (default `FALSE`)

age_grouping <- GroupConditions(
  conditions_category = "Age",
  "to 20" ~ age < 20,
  "20 to 40" ~ age >= 20 & age <= 40,
  "40 to 60" ~ age >= 40 & age < 60,
  force_disjoint = FALSE,
  force_exhaustive = TRUE
)
print(age_grouping)
}
