% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normalize.R
\name{normalize_scores_grouped}
\alias{normalize_scores_grouped}
\title{Normalize scores using GroupedFrequencyTables or GroupedScoreTables}
\usage{
normalize_scores_grouped(
  data,
  vars,
  ...,
  what,
  retain = FALSE,
  group_col = NULL,
  .dots = list()
)
}
\arguments{
\item{data}{data.frame object containing raw scores}

\item{vars}{names of columns to normalize. Length of vars
need to be the same as number of tables provided to either \code{...} or \code{.dots}}

\item{...}{\code{GroupedFrequencyTable} or \code{GroupedScoreTable} objects to be used
for normalization. They should be provided in the same order as \code{vars}}

\item{what}{the values to get. One of either:
\itemize{
\item \code{quan} - the quantile of x in the raw score distribution
\item \code{Z} - normalized Z score for the x raw score
\item name of the scale calculated in \code{GroupedScoreTables} provided to \code{...} or
\code{.dots} argument
}}

\item{retain}{either boolean: \code{TRUE} if all columns in the \code{data} are to be
retained, \code{FALSE} if none; or character vector with names of columns to be retained}

\item{group_col}{name of the column for name of the group each
observation was qualified into. If left as default \code{NULL}, they won't be returned.}

\item{.dots}{\code{GroupedFrequencyTable} or \code{GroupedScoreTable} objects provided
as a list, instead of individually in \code{...}.}
}
\value{
data.frame with normalized scores
}
\description{
Normalize scores using either \code{GroupedFrequencyTable} or
\code{GroupedScoreTable} for one or more variables. Given data.frame should also
contain columns used in \code{GroupingConditions} attached to the table
}
\examples{
# setup - create necessary objects #
suppressMessages({
  age_grouping <- GroupConditions(
    conditions_category = "Age",
    "below 22" ~ age < 22,
    "23-60" ~ age >= 23 & age <= 60,
    "above 60" ~ age > 60
  )
  sex_grouping <- GroupConditions(
    conditions_category = "Sex",
    "Male" ~ sex == "M",
    "Female" ~ sex == "F"
  )
  NEU_gft <- GroupedFrequencyTable(
    data = IPIP_NEO_300,
    conditions = list(age_grouping, sex_grouping),
    var = "N"
  )
  NEU_gst <- GroupedScoreTable(
    NEU_gft,
    scale = list(STEN, STANINE)
  )
})

#### normalize scores ####
# to Z score or quantile using GroupedFrequencyTable
normalized_to_quan <- normalize_scores_grouped(
  IPIP_NEO_300,
  vars = "N",
  NEU_gft,
  what = "quan",
  retain = c("sex", "age")
)

# only 'sex' and 'age' are retained
head(normalized_to_quan)

# to StandardScale attached to GroupedScoreTable
normalized_to_STEN <- normalize_scores_grouped(
  IPIP_NEO_300,
  vars = "N",
  NEU_gst,
  what = "stanine",
  retain = FALSE,
  group_col = "sex_age_group"
)

# none is retained, 'sex_age_group' is created
head(normalized_to_STEN)
}
\seealso{
Other score-normalization functions: 
\code{\link{normalize_scores_df}()},
\code{\link{normalize_scores_scoring}()},
\code{\link{normalize_score}()}
}
\concept{score-normalization functions}
